#pragma once

#include "operation.h"
#include "../events_data.h"

#include <yandex/maps/wiki/topo/editor.h>

#include <maps/libs/geolib/include/point.h>

namespace maps {
namespace wiki {
namespace topo {

class SaveEdgeOperation : public Operation {
public:
    SaveEdgeOperation(
        const Callbacks& callbacks,
        CacheImpl& cache,
        const Editor::EdgeData& data,
        const TopologyRestrictions& restrictions);

    void operator () (bool loadObjects = true);

private:
    SourceEdgeID id_;
    geolib3::Polyline2 geom_;
    geolib3::PointsVector splits_;
    const TopologyRestrictions restrictions_;
};

} // namespace topo
} // namespace wiki
} // namespace maps
