#pragma once

#include "../cache_impl.h"
#include "../geom_tools/intersector.h"
#include "process_events.h"

#include <maps/libs/geolib/include/polyline.h>

namespace maps {
namespace wiki {
namespace topo {

geolib3::Polyline2
prepareGeometry(const geolib3::Polyline2& geom);

void
preloadObjectsByGeometry(
    CacheImpl& cache,
    OptionalEdgeID id, const geolib3::Polyline2& geom,
    const TopologyRestrictions& restrictions);

typedef std::unique_ptr<SplitEdgeEventData> SplitDataPtr;

typedef std::map<EdgeID, EdgeIDSet> SplitEdgeIdsMap;

void
deleteUnusedNodes(CacheImpl& cache, const NodeIDSet& unusedNodeIds);

SplitEdgeIdsMap
processSplittedEdges(ProcessEvents& process, geom::Intersector::Events& events);

void
sendSplitEdgeEventOfIntersectedEdges(const Callbacks& callbacks, geom::Intersector::Events& events);

void
deleteMergedEdges(ProcessEvents& process, CacheImpl& cache, geom::Intersector::Events& events);

void
processEdgesSaving(CacheImpl& cache, const Callbacks& callbacks, geom::Intersector::Events& events);

} // namespace topo
} // namespace wiki
} // namespace maps
