#pragma once

#include "operation.h"
#include "../events_data.h"

#include <yandex/maps/wiki/topo/editor.h>

#include <maps/libs/geolib/include/point.h>

namespace maps {
namespace wiki {
namespace topo {

class SaveObjectsOperation : public Operation {
public:
    SaveObjectsOperation(
        const Callbacks& callbacks,
        CacheImpl& cache,
        const Editor::TopologyData& data,
        const TopologyRestrictions& restrictions);

    void operator () ();

private:
    void saveEdge(
        SourceEdgeID id,
        const geolib3::Polyline2& geom,
        boost::optional<IncidentNodes> originalIncidences);

    Editor::TopologyData data_;
    const TopologyRestrictions restrictions_;
};

} // namespace topo
} // namespace wiki
} // namespace maps
