#pragma once

#include "operation.h"
#include "../events_data.h"

#include <yandex/maps/wiki/topo/editor.h>

#include <maps/libs/geolib/include/point.h>

namespace maps {
namespace wiki {
namespace topo {

class SnapNodesOperation : public Operation {
public:
    SnapNodesOperation(
        const Callbacks& callbacks,
        CacheImpl& cache,
        const NodeIDSet& nodeIds,
        const TopologyRestrictions& restrictions);

    void operator () ();

private:
    void preloadObjects();

    struct SnapToEdgeResult {
        EdgeID nearestEdgeId;
        geolib3::Point2 newPos;
    };

    boost::optional<SnapToEdgeResult> trySnapToEdge(NodeID nodeId) const;

    OptionalNodeID trySnapToNode(NodeID nodeId, const geolib3::Point2& pos,
        NodeIDSet ignoredNodeIds) const;

    void saveAffectedEdges(const EdgeIDSet& affectedEdgeIds);

    void saveEdge(
        EdgeID id,
        const geolib3::Polyline2& geom,
        const IncidentNodes& originalIncidences);

    NodeIDSet nodeIds_;
    TopologyRestrictions restrictions_;
};

} // namespace topo
} // namespace wiki
} // namespace maps
