#include <yandex/maps/wiki/topo/editor.h>

#include "editor_impl.h"

namespace maps {
namespace wiki {
namespace topo {

Editor::Editor(std::unique_ptr<EditorImpl> impl)
    : impl_(std::move(impl))
{}

Editor::~Editor()
{ /* impl_ */ }

void Editor::saveEdge(
    const EdgeData& data,
    const TopologyRestrictions& restrictions)
{
    impl_->saveEdge(data, restrictions);
}

void Editor::saveNode(
    const NodeData& data,
    const TopologyRestrictions& restrictions)
{
    impl_->saveNode(data, restrictions);
}

void Editor::saveObjects(
    const TopologyData& data,
    const TopologyRestrictions& restrictions)
{
    impl_->saveObjects(data, restrictions);
}

Editor::CreateIntersectionsResult
Editor::createIntersections(
    const geolib3::PolylinesVector& geoms,
    const TopologyRestrictions& restrictions)
{
    return impl_->createIntersections(geoms, restrictions);
}

void Editor::deleteEdge(EdgeID id)
{
    impl_->deleteEdge(id);
}

void Editor::mergeEdges(NodeID commonNodeId)
{
    impl_->mergeEdges(commonNodeId);
}

void Editor::snapNodes(
    const NodeIDSet& nodeIds,
    const TopologyRestrictions& restrictions)
{
    impl_->snapNodes(nodeIds, restrictions);
}

double Editor::maxInteractionDistance(
    double gravityDistance)
{
    return 4 * gravityDistance;
}

double Editor::maxInteractionDistance(
    const TopologyRestrictions& restrictions)
{
    return Editor::maxInteractionDistance(restrictions.junctionGravity());
}

/// Callbacks registration

void
Editor::registerTopoCallback(std::unique_ptr<TopoAddEdgeCallback> callback)
{
    impl_->callbacks().addEdgeTopo.registerCallback(std::move(callback));
}

void
Editor::registerTopoCallback(std::unique_ptr<TopoMoveEdgeCallback> callback)
{
    impl_->callbacks().moveEdgeTopo.registerCallback(std::move(callback));
}

void
Editor::registerTopoCallback(std::unique_ptr<TopoDeleteEdgeCallback> callback)
{
    impl_->callbacks().deleteEdgeTopo.registerCallback(std::move(callback));
}

void
Editor::registerCallback(std::unique_ptr<SplitEdgeCallback> callback)
{
    impl_->callbacks().splitEdge.registerCallback(std::move(callback));
}

void
Editor::registerCallback(std::unique_ptr<MergeEdgesCallback> callback)
{
    impl_->callbacks().mergeEdges.registerCallback(std::move(callback));
}

void
Editor::registerCallback(std::unique_ptr<DeleteEdgeCallback> callback)
{
    impl_->callbacks().deleteEdge.registerCallback(std::move(callback));
}

void
Editor::registerCallback(std::unique_ptr<MergeNodesCallback> callback)
{
    impl_->callbacks().mergeNodes.registerCallback(std::move(callback));
}

} // namespace maps::wiki::topo
} // namespace maps::wiki
} // namespace maps
