#pragma once

#include "cache_impl.h"
#include "path_utils.h"

#include <yandex/maps/wiki/topo/face_validator.h>

namespace maps {
namespace wiki {
namespace topo {

class FaceValidator::Impl {
public:
    explicit Impl(CacheImpl& cache)
        : cache_(cache)
    {}

    void operator () (FaceID faceId);

private:
    /// Check that face edges are a single simple closed path
    ///   if all edges are available
    void validateCompleteFace(FaceID faceId, const EdgeIDSet& edgeIds);

    struct FaceDiffPaths {
        PathsList added;
        PathsList removed;
    };

    /// Build added and removed paths from face edges diff
    FaceDiffPaths
    buildFaceDiffPaths(FaceID faceId);

    /// Check that all nodes from paths added to face
    ///   still have 2 relations with elements within the face
    void checkAffectedNodes(FaceID contourId, const PathsList& addedPaths);

    CacheImpl& cache_;
};

} // namespace topo
} // namespace wiki
} // namespace maps
