#pragma once

#include "gen_doc/layer_builder.h"
#include "gen_doc/geotex_conversion.h"

#include "test_tools/storage_diff_helpers.h"

namespace maps {
namespace wiki {
namespace topo {
namespace doc {

typedef LayerBuilder<GeomGeotexConvertor> GeomLayerBuilder;

void
buildCommonResultEdgesLayers(
    const test::MockStorage& result,
    GeomLayerBuilder& builder, const test::EdgesDiffData& edgesDiff);

void
buildCommonResultNodesLayers(
    const test::MockStorage& result,
    GeomLayerBuilder& builder, const test::NodesDiff& nodesDiff);

std::list<geolib3::BoundingBox>
customGeomViewRects(
    const test::CommonTestData& testData, double poiRadius);


std::list<geotex::LayerPtr>
highlightLayers(
    const test::PrintInfo& printInfo,
    const TopologyRestrictions& restrictions,
    const test::MockStorage& storage,
    const geolib3::Polyline2* newEdgeGeom);

} // namespace doc
} // namespace topo
} // namespace wiki
} // namespace maps
