#pragma once

#include <yandex/maps/geotex/common.h>
#include <yandex/maps/geotex/scene.h>

namespace maps {
namespace wiki {
namespace topo {
namespace doc {

template <class T>
struct TrueFilter {
    bool operator () (const T&) const { return true; }
};

template <class Convertor>
class LayerBuilder {
public:
    LayerBuilder(const Convertor& convertor, std::list<geotex::LayerPtr>& layers)
        : convertor_(convertor)
        , layers_(layers)
    {}

    template <
        class Collection,
        class Filter = TrueFilter<typename Collection::value_type>
    >
    void
    add(
        std::pair<std::string, geotex::ObjectStyle> layerData,
        const Collection& collection,
        const Filter& filter = Filter())
    {
        auto layer = std::make_shared<geotex::Layer>(layerData.first, layerData.second);
        for (const auto& object : collection) {
            if (filter(object)) {
                layer->append(convertor_(object));
            }
        }
        layers_.push_back(layer);
    }

private:
    const Convertor& convertor_;
    std::list<geotex::LayerPtr>& layers_;
};

} // namespace doc
} // namespace topo
} // namespace wiki
} // namespace maps
