#pragma once

#include <yandex/maps/geotex/common.h>

namespace maps {
namespace wiki {
namespace topo {
namespace doc {
namespace style {

/**
 * Common styles
 */

#define DEFINE_NODE_STYLE(name, marker_style_id, fill_color, stroke_color) \
const geotex::ObjectStyle name( \
    std::string(fill_color), \
    std::string(stroke_color), \
    geotex::ObjectStyle::NO_PATTERN, \
    std::string(marker_style_id));

DEFINE_NODE_STYLE(ALL_NODES, "ccircle", "black", "black")
DEFINE_NODE_STYLE(AFFECTED_NODES_BEFORE, "ccircle", "red", "red")
DEFINE_NODE_STYLE(CREATED_NODES_AFTER, "ccircle", "green!60!yellow", "green!60!black")
DEFINE_NODE_STYLE(MOVED_NODES_AFTER, "ccircle", "violet!60!white", "violet!60!black")
DEFINE_NODE_STYLE(AFFECTED_NODES_AFTER, "ccircle", "brown!60!yellow", "brown!60!black")
DEFINE_NODE_STYLE(NEW_EDGE_ENDPOINTS, "cring", "blue", "blue")
DEFINE_NODE_STYLE(REQUESTED_SPLIT_POINTS, "ccross", "blue!50!red", "blue!50!red")
DEFINE_NODE_STYLE(NEW_NODE_POS, "cring", "blue", "blue")
DEFINE_NODE_STYLE(MOVED_NOVE, "ccircle", "yellow", "yellow")
DEFINE_NODE_STYLE(MOVED_NODE_HIGHLIGHT_BEFORE, "cring", "red", "red")
DEFINE_NODE_STYLE(MOVED_NODE_HIGHLIGHT_AFTER, "cring", "green", "green")

#undef DEFINE_NODE_STYLE

#define DEFINE_EDGE_STYLE(name, color, style) \
const geotex::ObjectStyle name( \
    geotex::ObjectStyle::NO_FILL, \
    std::string(color), \
    geotex::ObjectStyle::NO_PATTERN, \
    geotex::ObjectStyle::NO_MARKER, \
    std::string(style), \
    /* bool showLineDirection = */ true);

DEFINE_EDGE_STYLE(ALL_EDGES, "black", "very thick")
DEFINE_EDGE_STYLE(EDITED_EDGES_BEFORE, "orange", "very thick")
DEFINE_EDGE_STYLE(NEW_GEOM, "blue", "very thick,dashed")
DEFINE_EDGE_STYLE(EDITED_EDGES_NEW_PARTS_AFTER, "green", "very thick")
DEFINE_EDGE_STYLE(AFFECTED_EDGES_NEW_PARTS_AFTER, "green!70!black", "very thick")
DEFINE_EDGE_STYLE(EDITED_EDGES_MOVED_PARTS_AFTER, "brown!60!yellow", "very thick")
DEFINE_EDGE_STYLE(AFFECTED_EDGES_MOVED_PARTS_AFTER, "brown!60!black", "very thick")
DEFINE_EDGE_STYLE(EDITED_EDGES_CHANGED_PARTS_AFTER, "violet!60!white", "very thick")
DEFINE_EDGE_STYLE(AFFECTED_EDGES_CHANGED_PARTS_AFTER, "violet!60!black", "very thick")

DEFINE_EDGE_STYLE(FACE_EDGES_BEFORE, "orange", "very thick")
DEFINE_EDGE_STYLE(ADDED_FACE_EDGES, "green!75!black", "very thick")
DEFINE_EDGE_STYLE(CHANGED_FACE_EDGES, "brown", "very thick")
DEFINE_EDGE_STYLE(REMOVED_FACE_EDGES, "red", "very thick")

#undef DEFINE_EDGE_STYLE

#define DEFINE_GRAVITY_STYLE(name, color, pattern_id) \
const geotex::ObjectStyle name(std::string(color), std::string(color), std::string(pattern_id));

DEFINE_GRAVITY_STYLE(POINT_TOLERANCE, "blue", "chatch")
DEFINE_GRAVITY_STYLE(POINT_VERTEX_GRAVITY, "orange", "chatch")
DEFINE_GRAVITY_STYLE(POINT_JUNCTION_GRAVITY, "red", "chatch")

DEFINE_GRAVITY_STYLE(EDGE_TOLERANCE, "blue", "cdots")
DEFINE_GRAVITY_STYLE(EDGE_VERTEX_GRAVITY, "orange", "cdots")
DEFINE_GRAVITY_STYLE(EDGE_JUNCTION_GRAVITY, "red", "cdots")

#undef DEFINE_GRAVITY_STYLE

const std::string NODE_LABELS = "ellipse,inner sep=1.5pt";
const std::string EDGE_LABELS = "rectangle,inner sep=2.5pt";

} // namespace style
} // namespace doc
} // namespace topo
} // namespace wiki
} // namespace maps
