#include "geom_io.h"


namespace maps {
namespace wiki {
namespace topo {
namespace geom {

std::ostream& operator<<(std::ostream& out, const SplitPoint& point)
{
    return out << "{"
               << point.geom << "," << point.nodeId
               << "}";
}


std::ostream& operator<<(std::ostream& out, const SnapPoint& point)
{
    return out << "{"
               << point.geom() << ","
               << point.node() << ","
               << point.edge() << ","
               << point.vertexIndex() << ","
               << point.segmentIndex()
               << "}";
}

std::ostream& operator<<(std::ostream& out, const SplitPolyline& polyline)
{
    return out << "{"
               << polyline.geom << ", " << polyline.edgeId
               << "}";
}

std::ostream& operator<<(std::ostream& out, const SnapPolyline& polyline)
{
    return out << polyline.points();
}


std::ostream& operator<<(std::ostream& out, const SourceEdgeID& sourceEdgeId)
{
    return out << "("
               << sourceEdgeId.id() << ","
               << (sourceEdgeId.exists() ? "true" : "false")
               << ")";
}

std::ostream& operator<<(std::ostream& out, const SplitEdgeEventData& data)
{
    out << "SplitEdgeEventData {\n"
        << "\t" << data.sourceId << "\n"
        << "\t" << data.polyline << "\n"
        << "\t" << data.splitPoints << "\n";

    for (const auto& polyline: data.splitPolylines) {
        out << "\t" << polyline << "\n";
    }

    return out << "\t" << data.partToKeepIDIndex << "\n"
               << "}";
}

std::ostream& operator<<(std::ostream& out, const Intersector::Events& events)
{
    out << "Events:\n";
    out << *events.editedEdgeEvent << std::endl;
    for (const auto& pair: events.intersectedEdgesEvents) {
        out << pair.first << ": " << *pair.second << std::endl;
    }
    out << "Unused nodes: { ";
    for (const auto& id: events.unusedNodeIds) {
        out << id << " ";
    }
    return out << "}" << std::endl;
}


} // namespace geom
} // namespace topo
} // namespace wiki

namespace geolib3 {

std::ostream& operator<<(std::ostream& out, const Point2& point)
{
    const std::streamsize precision = out.precision(2);
    const std::ios_base::fmtflags flags = out.flags();
    out << std::fixed << std::noshowpoint
        << "("
        << point.x() << ", " << point.y()
        << ")";
    out.precision(precision);
    out.flags(flags);
    return out;
}

std::ostream& operator<<(std::ostream& out, const Segment2& segment)
{
    return out << "[" << segment.start() << ", " << segment.end() << "]";
}

std::ostream& operator<<(std::ostream& out, const Polyline2& polyline)
{
    using wiki::topo::geom::operator<<;
    return out << polyline.points();
}

} // namespace geolib3
} // namespace maps
