#pragma once

#include "types.h"

#include <yandex/maps/wiki/topo/common.h>
#include <maps/libs/geolib/include/polyline.h>

#include <unordered_map>


namespace maps {
namespace wiki {
namespace topo {
namespace geom {


class SplitEdgeEventMaker {

public:

    // Prepare data of split events for edited edge.
    // * sourceEdgeId - source edge id of splitted edge;
    // * polyline - aligned geometry;
    // * splits - list of split polylines, split can consist of one point and
    // both end points of edge must be included.
    SplitEdgeEventDataPtr makeForEditedEdge(const SourceEdgeID& sourceEdgeId,
        const SnapPolyline& polyline, const SnapPolylineVector& splits);

    // Prepare data of split events for intersected edge.
    // * sourceEdgeId - source edge id of splitted edge;
    // * polyline - old geomentry;
    // * splits - list of split polylines, split can consist of one point and
    // both end points of edge must be included.
    SplitEdgeEventDataPtr makeForIntersectedEdge(const Edge& edge,
        const SnapPolylineVector& splits);

private:

    SplitPointPtr cache(const SnapPoint& snapPoint);
    SplitPolylinePtr cache(const SnapPolyline& snapPolyline);

    std::unordered_map<SnapPoint, SplitPointPtr> points_;
    std::unordered_map<SnapPolyline, SplitPolylinePtr> polylines_;
};

} // namespace maps::wiki::topo::geom
} // namespace maps::wiki::topo
} // namespace maps::wiki
} // namespace maps

