#pragma once

#include "intersector.h"
#include "../graph.h"

#include <yandex/maps/wiki/topo/common.h>
#include <yandex/maps/wiki/topo/node.h>

#include <maps/libs/geolib/include/polyline.h>

#include <vector>


namespace maps {
namespace wiki {
namespace topo {
namespace geom {

void checkMaxIntersectedEdges(const Intersector::Events& events, double limit);

void checkMaxIntersectionsWithEdge(const Intersector::Events& events, double limit);

void checkSegmentsLimits(const geolib3::Polyline2& polyline, const Limits<double>& limits);

void checkUnusedNodes(const std::vector<Node>& nodes, DeleteNodeChecker check);

void checkPolylineLimits(const geolib3::Polyline2& polyline, const Limits<double>& limits);

void checkNoSelfInteraction(const geolib3::Polyline2& polyline, double tolerance);

void checkNoInteraction(const Graph& graph, const Intersector::Events& events, double tolerance);

} // namespace geom
} // namespace topo
} // namespace wiki
} // namespace maps
