#pragma once

#include <yandex/maps/wiki/topo/common.h>

#include <maps/libs/geolib/include/point.h>

#include <memory>

namespace maps {
namespace wiki {
namespace topo {

typedef std::vector<Node> NodeVector;

class Edge;

class Graph;

class Node {
public:
    Node(NodeID id, const geolib3::Point2& pos);

    Node(const Node&);
    Node& operator=(const Node&);

    Node(Node&&);
    Node& operator=(Node&&);

    ~Node();

    NodeID id() const;
    /// Returns vector of unique edges
    EdgeConstPtrVector incidentEdges() const;
    EdgeIDVector incidentEdgeIds() const;
    const geolib3::Point2& pos() const;

    /// Node degree = total number of incident edges
    /// Every edge that makes a loop at the node is counted twice
    size_t degree() const;

    bool isIsolated() const;
    bool isPendant() const;

    bool isIncident(EdgeID edge) const;
    bool isStartOf(EdgeID edge) const;
    bool isEndOf(EdgeID edge) const;

private:
    friend class Graph;
    friend class CacheImpl;

    class Impl;

    std::unique_ptr<Impl> impl_;
};

} // namespace topo
} // namespace wiki
} // namespace maps
