#pragma once

#include <yandex/maps/wiki/topo/node.h>

namespace maps {
namespace wiki {
namespace topo {

class Node::Impl {
public:
    explicit Impl(NodeID id);
    Impl(NodeID id, const geolib3::Point2& pos);

    NodeID id() const { return id_; }

    const geolib3::Point2& pos() const { return pos_; }
    void setPos(const geolib3::Point2& pos) { pos_ = pos; }

    void addEdge(Edge* edge, IncidenceType incidenceType);
    void removeEdge(EdgeID edge, IncidenceType incidenceType);

    bool isStartOf(EdgeID edgeId) const;
    bool isEndOf(EdgeID edgeId) const;

    const EdgePtrVector& startIncidentEdges() const { return startEdges_; }
    const EdgePtrVector& endIncidentEdges() const { return endEdges_; }

    EdgePtrVector incidentEdges();

    bool areIncidentEdgesLoaded() const { return areIncidentEdgesLoaded_; }
    void setIncidentEdgesLoaded() { areIncidentEdgesLoaded_ = true; }

private:
    const NodeID id_;
    /// Edges that start at node
    EdgePtrVector startEdges_;
    /// Edges that end at node
    EdgePtrVector endEdges_;
    geolib3::Point2 pos_;
    /// true if node is loaded with all incident edges
    bool areIncidentEdgesLoaded_;
};

} // namespace topo
} // namespace wiki
} // namespace maps
