#pragma once

#include <yandex/maps/wiki/topo/common.h>

#include <list>
#include <map>
#include <string>
#include <set>

namespace maps {
namespace wiki {
namespace topo {

struct Path {
    bool isClosed() const { return startNodeId == endNodeId; }

    NodeID startNodeId;
    NodeID endNodeId;
    std::list<EdgeID> edgeIds;
    std::list<NodeID> nodeIds;
};

typedef std::list<Path> PathsList;


const std::string& incidenceToStr(const IncidenceType& incidenceType);

struct NodeIncidenceCompare {
    bool operator () (const Incidence& l, const Incidence& r) const
    {
        return l.edge < r.edge || (l.edge == r.edge && l.type < r.type);
    }
};

typedef std::set<Incidence, NodeIncidenceCompare> IncidencesSet;

typedef std::map<NodeID, IncidencesSet> IncidencesSetByNodeMap;


IncidencesByNodeMap
incidencesByEdgesToIncidencesByNodes(const IncidencesByEdgeMap& incidences);

IncidencesSetByNodeMap
incidencesByEdgesToIncidencesSetByNodes(const IncidencesByEdgeMap& incidences);

PathsList
buildPaths(const IncidencesByEdgeMap& incidences);

} // namespace topo
} // namespace wiki
} // namespace maps
