#pragma once

#include "../geom_tools/geom_io.h"
#include "../test_tools/test_io.h"

#include <ostream>

namespace maps {
namespace wiki {
namespace topo {
namespace util {


// Boost test library intensively uses macroses.
// This class help to find overloaded operator:
// std::ostream& operator<<(std::ostream& out, const TObject& object);
template<typename TObject>
class Printer{

public:
    explicit Printer(const TObject& object): object_(object) {}

    const TObject& operator*() const { return object_; }

private:
    const TObject& object_;
};

template<typename TObject>
std::ostream& operator<<(std::ostream& out, const Printer<TObject>& printer)
{
    using maps::wiki::topo::geom::operator<<;
    using maps::wiki::topo::test::operator<<;

    return out << *printer;
}

template<typename TObject>
Printer<TObject> print(const TObject& object)
{
    return Printer<TObject>{object};
}


} // namespace maps::wiki::topo::util
} // namespace maps::wiki::topo
} // namespace maps::wiki
} // namespace maps
