#pragma once

#include <yandex/maps/wiki/unittest/localdb.h>

#include <library/cpp/testing/unittest/registar.h>

#include <type_traits>


#define WIKI_FIXTURE_TEST_CASE(testName, Fixture)       \
    class Runner##testName##Fixture : public Fixture    \
    {                                                   \
    public:                                             \
        void doTest();                                  \
    };                                                  \
                                                        \
    Y_UNIT_TEST(testName) {                             \
        Runner##testName##Fixture runMe;                \
        runMe.doTest();                                 \
    }                                                   \
                                                        \
    void Runner##testName##Fixture::doTest()


/// Runs a testcase for all values from the container.
/// The current value can be accessed by calling `getParam()` method.
///
/// Usage:
///     WIKI_FIXTURE_TEST_CASE_P(should_run_for_each_param, Fixture, (std::array{1, 2, 3}))
///     {
///         UNIT_ASSERT(1 <= getParam() && getParam() <= 3); // Pass all three times.
///         UNIT_ASSERT(getParam() == 2);                    // Fail twice out of three times.
///     }
#define WIKI_FIXTURE_TEST_CASE_P(testName, Fixture, container)          \
    class Runner##testName##Fixture: public Fixture                     \
    {                                                                   \
    public:                                                             \
        using Param = std::decay_t<decltype(*container.begin())>;       \
        Runner##testName##Fixture(const Param& param): param_(param) {} \
        void doTest();                                                  \
                                                                        \
    private:                                                            \
        const Param& param_;                                            \
        const Param& getParam() const { return param_; }                \
    };                                                                  \
                                                                        \
    Y_UNIT_TEST(testName) {                                             \
        for (const auto& param: container) {                            \
            Cout << "Run parametrized test for " << param << ".\n";     \
            Runner##testName##Fixture runMe(param);                     \
            runMe.doTest();                                             \
        }                                                               \
    }                                                                   \
                                                                        \
    void Runner##testName##Fixture::doTest()


namespace maps::wiki::unittest {

/**
 * All instances of the class use the single local Postgres instance.
 * It speeds up tests execution by avoiding starting a new Postgres for each test.
 *
 * Lazily creates a new database from a template with mapspro migrations applied.
 * It speeds up tests listing (`ya make -L`) by skipping heavy opeations in ctor.
 */
class ArcadiaDbFixture : public NUnitTest::TBaseFixture
{
public:
    local_postgres::Database& database();

    pgpool3::Pool& pool();

    std::string connectionString();

    void executeSqlInTransaction(const std::string& sql);

private:
    std::unique_ptr<local_postgres::Database> database_;
    std::unique_ptr<pgpool3::Pool> pool_;
};

} // maps::wiki::unittest
