#pragma once

#include <maps/libs/local_postgres/include/instance.h>

#include <boost/filesystem.hpp>

#include <string>
#include <memory>

namespace maps {
namespace wiki {
namespace unittest {

/// Creates XML config for pgpool initialization
class ConfigFileHolder
{
public:
    ConfigFileHolder(
        const std::string& host,
        uint64_t port,
        const std::string& dbname,
        const std::string& user,
        const std::string& password,
        const std::string& services = {},
        const std::string& extend = {});
    ConfigFileHolder(
        const local_postgres::Database& database,
        const std::string& services = {},
        const std::string& extend = {});
    ~ConfigFileHolder();

    std::string filepath() const { return filepath_.string(); }

private:
    boost::filesystem::path filepath_;
};

} // unittest
} // wiki
} // maps
