#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>

#include <maps/libs/local_postgres/include/instance.h>

#include <memory>
#include <string>

namespace maps {
namespace wiki {
namespace unittest {

/// Brings up a local Postgres instance on a random port.
class RandomDatabaseFixture {
public:
    RandomDatabaseFixture();
    virtual ~RandomDatabaseFixture() = default;

    pgpool3::Pool& pool();

    const std::string& host() const;
    uint16_t port() const;
    const std::string& dbname() const;
    const std::string& user() const;
    const std::string& password() const;
    const std::string& connectionString() const;

    void executeSqlInTransaction(const std::string& sql)
    {
        database_.executeSqlInTransaction(sql);
    }

protected:
    pgpool3::Pool createPool();

    local_postgres::Database database_;

    pgpool3::Pool pool_;

    std::string connectionString_;
};

/// Creates a local DB with applied mapspro migrations.
/// Deprecated. Use ArcadiaDbFixture instead.
class MapsproDbFixture: public RandomDatabaseFixture {
public:
    MapsproDbFixture();
};


} // unittest
} // wiki
} // maps
