#pragma once

#include <boost/optional.hpp>
#include <boost/test/predicate_result.hpp>
#include <pqxx/pqxx>

#include <ostream>
#include <string>

namespace maps::wiki::unittest {

class QueryHelpers {
public:
    explicit QueryHelpers(pqxx::connection& conn)
        : conn_(conn)
    {}

    void applySqlFile(const std::string& file, const boost::optional<std::string>& schema);
    void applySqlFiles(const std::string& dir);

    pqxx::result applyQuery(const std::string& query);
    pqxx::result applyQueryToSchema(const std::string& schema, const std::string& query);

    void printQueryResult(std::ostream& os, const pqxx::result& rows) const;
    void printQueryResult(std::ostream& os, const std::string& query) const;
    void printTable(std::ostream& os, const std::string& table) const;

    boost::test_tools::predicate_result
    compareRows(
        const std::string& lhsQuery, const std::string& rhsQuery,
        const pqxx::result& lhsRows, const pqxx::result& rhsRows) const;

    boost::test_tools::predicate_result
    compareQueries(const std::string& lhsQuery, const std::string& rhsQuery);

    boost::test_tools::predicate_result
    compareQueries(
        pqxx::transaction_base& txn,
        const std::string& lhsQuery, const std::string& rhsQuery) const;

private:
    pqxx::connection& conn_;
};

} // namespace maps::wiki::unittest
