#pragma once

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/extended_xml_doc.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/pgpool3_helpers.h>
#include <maps/libs/chrono/include/time_point.h>
#include <util/stream/output.h>

#include <memory>
#include <string>

// Makes available `UNIT_ASSERT_VALUES_EQUAL(json::Value(), json::Value());`
template <>
inline void Out<maps::json::Value>(
    IOutputStream& os,
    const maps::json::Value& json)
{
    os << json;
}

namespace maps::wiki::unittest {

/// Fixture for locking and cleaning database before tests start
/// @param configFile path to configuration file
/// @param tag unique tag used to generate pg advisory lock id
class DatabaseFixture {
public:
    DatabaseFixture(
            const std::string& configFile,
            const std::string& tag,
            const std::string& migrationsPath);
    DatabaseFixture(
            const std::string& configFile,
            const std::string& dbId,
            const std::string& tag,
            const std::string& migrationsPath);

    virtual ~DatabaseFixture();

    DatabaseFixture(DatabaseFixture&&) = default;
    DatabaseFixture& operator=(DatabaseFixture&&) = default;

    common::ExtendedXmlDoc& configXml();
    common::PoolHolder& poolHolder();
    pgpool3::Pool& pool();

private:
    void init();
    void pgLock();
    void pgUnlock();

    std::unique_ptr<common::ExtendedXmlDoc> configXmlPtr_;
    common::PoolHolder poolHolder_;
    pgpool3::TransactionHandle lockTxn_;
    std::string lockId_;
    std::string migrationsPath_;
};

chrono::TimePoint txnNow(pqxx::transaction_base& txn);

} // maps::wiki::unittest
