#include <yandex/maps/wiki/unittest/query_helpers.h>
#include <yandex/maps/wiki/unittest/query_helpers_common.h>

#include "util.h"

namespace maps::wiki::unittest {

void QueryHelpers::applySqlFile(const std::string& file, const boost::optional<std::string>& schema)
{
    unittest::applySqlFile(conn_, file, schema);
}

void QueryHelpers::applySqlFiles(const std::string& dir)
{
    unittest::applySqlFiles(conn_, dir);
}

pqxx::result QueryHelpers::applyQuery(const std::string& query)
{
    return unittest::applyQuery(conn_, query, boost::none);
}

pqxx::result QueryHelpers::applyQueryToSchema(const std::string& schema, const std::string& query)
{
    return unittest::applyQuery(conn_, query, schema);
}

void QueryHelpers::printQueryResult(std::ostream& os, const pqxx::result& rows) const
{
    unittest::printQueryResult(os, rows);
}

void QueryHelpers::printQueryResult(std::ostream& os, const std::string& query) const
{
    pqxx::work txn(conn_);
    printQueryResult(os, txn.exec(query));
}

void QueryHelpers::printTable(std::ostream& os, const std::string& table) const
{
    os << table << "\n";
    printQueryResult(os, "SELECT * FROM " + table + ";");
}

boost::test_tools::predicate_result
QueryHelpers::compareRows(
    const std::string& lhsQuery, const std::string& rhsQuery,
    const pqxx::result& lhsRows, const pqxx::result& rhsRows) const
{
    auto [areRowsEqual, message] = unittest::compareRows(lhsQuery, rhsQuery, lhsRows, rhsRows);
    if (!areRowsEqual) {
        auto result = boost::test_tools::predicate_result(false);
        result.message() << message;
        return result;
    }
    return true;
}

boost::test_tools::predicate_result
QueryHelpers::compareQueries(const std::string& lhsQuery, const std::string& rhsQuery)
{
    auto lhsRows = applyQuery(lhsQuery);
    auto rhsRows = applyQuery(rhsQuery);
    return compareRows(lhsQuery, rhsQuery, lhsRows, rhsRows);
}

boost::test_tools::predicate_result
QueryHelpers::compareQueries(
    pqxx::transaction_base& txn,
    const std::string& lhsQuery, const std::string& rhsQuery) const
{
    return compareRows(lhsQuery, rhsQuery, txn.exec(lhsQuery), txn.exec(rhsQuery));
}

} // namespace maps::wiki::unittest
