#pragma once

#include <library/cpp/testing/common/env.h>

#include <boost/optional.hpp>
#include <pqxx/pqxx>

#include <string>

namespace maps {
namespace wiki {
namespace unittest {

const std::string DEFAULT_MAPSPRO_DB_MIGRATIONS_PATH =
    ArcadiaSourceRoot() + "/maps/wikimap/mapspro/migrations/migrations";

void dropNonSystemSchemas(pqxx::connection& conn);
void createPublicSchema(pqxx::connection& conn);
void applyMigrations(pqxx::connection& conn, const std::string& dir);
pqxx::result applyQuery(pqxx::connection& conn, const std::string& query, const boost::optional<std::string>& schema);
pqxx::result applySqlFile(pqxx::connection& conn, const std::string& filename, const boost::optional<std::string>& schema);
void applySqlFiles(pqxx::connection& conn, const std::string& dir);
std::string makeLockIdStr(const std::string& tag);

} // unittest
} // wiki
} // maps
