# Библиотека для валидации объектов Народной карты

## Загрузка объектов

Для того, чтобы провалидировать объекты, их нужно сначала загрузить из базы данных в память.

Выбор объектов для загрузки зависит от параметров запуска задачи:
* список проверок
* запуск по зоне/региону или по всему миру
* запуск по списку объектов

В метаданных каждой проверки указан список категорий объектов, которые нужны для этой проверки. Например:

```
VALIDATOR_SIMPLE_CHECK(rd_ad_relations, RD, RD_NM, AD, AD_NM)
```

Имея список проверок, можно получить список всех необходимых категорий для загрузки. Обозначим его *INITIAL_CATEGORIES*.

Всего имеется 3 режима загрузки объектов.

### 1. Загрузка всех объектов

Режим активируется, если не указана зона/регион проверки, и не указан явно список объектов для загрузки.

Загружаются все объекты категорий из списка *INITIAL_CATEGORIES*.

### 2. Загрузка по зоне/региону

Режим активируется, если указана зона/регион проверки, и не указан явно список объектов для загрузки.

Главная проблема здесь: сложные объекты не имеют геометрии и не могут быть загружены сразу, но могут быть загружены по связям с объектами других категорий.

Для этого нужен граф зависимостей категорий. Например:

```
AD_NM -> AD -> AD_JC -> AD_EL
```

Сначала загружаются объекты с геометрией, если их геометрия пересекает зону/регион проверки. Такие категории не имееют зависимостей.

Потом загружаются сложные объекты вверх по иерархии, в конце - табличные атрибуты. В итоге, оказываются загруженными больше категорий, чем указано в списке *INITIAL_CATEGORIES*.

### 3. Загрузка по списку объектов

Обозначим изначальный список объектов *INITIAL_OBJECTS*.

Обычно проверки валидатора проверяют не только сам объектов, но и его связи с другими объектами. Для этого они должны быть загружены в память.

Загружать только объекты вверх по иерархии не достаточно. Например: пусть мы изменили участок дороги так, что поломали топологию. При этом в память будут загружен только один родительский объект - дорога, которого не достаточно для проверки корректности топологии.

Поэтому алгоритм состоит из 2х шагов:

Шаг 1. Для каждого объекта из списка *INITIAL_OBJECTS* загрузить всех его родителей вверх по иерархии.
Шаг 2. Пройтись вниз по иерархии и загрузить все геом-парты у макрообъектов.

Чтобы в графе зависимостей не образовалось циклов, шаг 1 спрятан внутри алгоритма загрузки. Снаружи доступен граф зависимостей для шага 2:

```
AD_JC -> AD_EL -> AD_FC -> AD
```

### Интерфейс

Загрузчики всех 3 типов для каждой категории иницилизируются один раз при запуске воркера. Для этого используется информация из конфига редактора.

Снаружи загрузчики доступны через класс `ValidatorConfig`:
* метод `ValidatorConfig::categoryRevisionIdsLoader` возвращает функцию-загручик
* метод `ValidatorConfig::loaderDependencies` возвращает список зависимостей у категории.

В режиме загрузки по списку объектов функция-загрузчик для категорий верхнего уровня **неявно** загружает объекты по связям с геомпартами из списка *INITIAL_OBJECTS*.
