#pragma once

#include <yandex/maps/wiki/validator/check_context.h>

#include "check_meta.h"
#include "task_messages.h"
#include "loader/data_source.h"

namespace maps::wiki::validator {

class CheckContext::Impl
{
public:
    Impl(
            const TCheckId& checkId,
            const CheckPartMeta& checkPart,
            const DataSource& dataSource,
            TaskMessages& taskMessages,
            ThreadPool& pool)
        : checkId_(checkId)
        , checkPart_(checkPart)
        , dataSource_(dataSource)
        , taskMessages_(taskMessages)
        , pool_(pool)
    { }

    const AreaOfInterest& aoi() const
    { return dataSource_.aoi(); }

    bool canSkipValidation(const std::string& categoryId, TId objectId) const
    {
        if (dataSource_.hasSelectedObjectIds()) {
            const auto& objectIds = dataSource_.selectedObjectIds(categoryId);
            return objectIds.count(objectId) == 0;
        }
        return false;
    }

    const ObjectsCollectionsTuple& collectionsTuple() const
    { return dataSource_.collectionsTuple(); }

    ThreadPool& threadPool() const
    { return pool_; }

    template<typename TGeom>
    void report(
        Severity severity,
        std::string description,
        const TGeom& geometry,
        const std::vector<TId>& oids,
        MessageKeyGenerator keyGenerator,
        MessageComparator messageComparator);

private:
    template<typename TGeom>
    void baseReport(
        Severity severity,
        std::string description,
        const TGeom& geometry,
        const std::vector<TId>& oids,
        MessageKeyGenerator keyGenerator,
        MessageComparator messageComparator);

    const TCheckId& checkId_;
    const CheckPartMeta& checkPart_;
    const DataSource& dataSource_;
    TaskMessages& taskMessages_;
    ThreadPool& pool_;
};

} // namespace maps::wiki::validator
