#include "exception.h"

namespace maps {
namespace wiki {
namespace validator {

ObjectLoadingException::ObjectLoadingException(
        std::string description,
        TId oid,
        boost::optional<geolib3::Point2> geom)
    : description_(std::move(description))
    , oid_(oid)
    , geom_(std::move(geom))
{
    *this << "Exception while loading object id: " << oid << ": " << description;
}

ObjectLoadingException::~ObjectLoadingException() noexcept = default;

InvalidRelationsException::InvalidRelationsException(
        std::string description,
        TId thisOid,
        std::vector<TId> otherOids,
        Severity severity)
    : ObjectLoadingException(std::move(description), thisOid)
    , otherOids_(std::move(otherOids))
    , severity_(severity)
{
    *this << ", relatedOids:";
    for (TId otherOid : otherOids_) {
        *this << ' ' << otherOid;
    }
}

InvalidRelationsException::~InvalidRelationsException() noexcept = default;

} // namespace validator
} // namespace wiki
} // namespace maps
