#pragma once

#include <yandex/maps/wiki/validator/message.h>

#include <maps/libs/common/include/exception.h>
#include <maps/libs/geolib/include/point.h>
#include <boost/optional.hpp>

#include <vector>

namespace maps {
namespace wiki {
namespace validator {

class ObjectLoadingException : public maps::Exception
{
public:
    ObjectLoadingException(
            std::string description,
            TId oid,
            boost::optional<geolib3::Point2> geom = boost::none);

    const std::string& description() const
    { return description_; }

    TId oid() const
    { return oid_; }

    const boost::optional<geolib3::Point2>& geom() const
    { return geom_; }

    virtual ~ObjectLoadingException() noexcept;
private:
    std::string description_;
    TId oid_;
    boost::optional<geolib3::Point2> geom_;
};

class InvalidRelationsException : public ObjectLoadingException
{
public:
    InvalidRelationsException(
            std::string description,
            TId thisOid,
            std::vector<TId> otherOids,
            Severity severity = Severity::Fatal);

    const std::vector<TId>& otherOids() const
    { return otherOids_; }

    Severity severity() const
    { return severity_; }

    virtual ~InvalidRelationsException() noexcept;

private:
    std::vector<TId> otherOids_;
    Severity severity_;
};

inline void requireOnObjectLoad(
        bool condition,
        std::string description,
        TId oid,
        boost::optional<geolib3::Point2> geom = boost::none)
{
    if (!condition) {
        throw ObjectLoadingException(
            std::move(description),
            oid,
            std::move(geom));
    }
}

} // namespace validator
} // namespace wiki
} // namespace maps
