#pragma once

#include <string>

namespace maps {
namespace wiki {
namespace validator {

const char MULTIVALUE_ATTR_DELIMITER = '|';

const std::string REL_MASTER_ATTR = "rel:master";
const std::string REL_SLAVE_ATTR = "rel:slave";
const std::string REL_ROLE_ATTR = "rel:role";
const std::string REL_SEQ_NUM_ATTR = "rel:seq_num";

const std::string VEHICLE_RESTRICTION_WEIGHT_LIMIT_ATTR = "vehicle_restriction:weight_limit";
const std::string VEHICLE_RESTRICTION_AXLE_WEIGHT_LIMIT_ATTR = "vehicle_restriction:axle_weight_limit";
const std::string VEHICLE_RESTRICTION_MAX_WEIGHT_LIMIT_ATTR = "vehicle_restriction:max_weight_limit";
const std::string VEHICLE_RESTRICTION_HEIGHT_LIMIT_ATTR = "vehicle_restriction:height_limit";
const std::string VEHICLE_RESTRICTION_WIDTH_LIMIT_ATTR = "vehicle_restriction:width_limit";
const std::string VEHICLE_RESTRICTION_LENGTH_LIMIT_ATTR = "vehicle_restriction:length_limit";
const std::string VEHICLE_RESTRICTION_PAYLOAD_LIMIT_ATTR = "vehicle_restriction:payload_limit";
const std::string VEHICLE_RESTRICTION_MIN_ECO_CLASS_ATTR = "vehicle_restriction:min_eco_class";
const std::string VEHICLE_RESTRICTION_TRAILER_NOT_ALLOWED_ATTR = "vehicle_restriction:trailer_not_allowed";

const std::string RD_TYPE_ATTR = "rd:rd_type";
const std::string RD_SEARCH_CLASS_ATTR = "rd:search_class";
const std::string BLD_HEIGHT_ATTR = "bld:height";
const std::string AD_SUBST_IS_VIRTUAL_ATTR = "ad_subst:is_virtual";

const std::string SCHEDULE_DATE_END_ATTR_SUFFIX = ":date_end";
const std::string SCHEDULE_DATE_START_ATTR_SUFFIX = ":date_start";
const std::string SCHEDULE_DAY_ATTR_SUFFIX = ":day";
const std::string SCHEDULE_FREQ_ATTR_SUFFIX = ":freq";
const std::string SCHEDULE_TIME_END_ATTR_SUFFIX = ":time_end";
const std::string SCHEDULE_TIME_START_ATTR_SUFFIX = ":time_start";
const std::string SCHEDULE_DEPARTURE_TIME_ATTR_SUFFIX = ":departure_time";
const std::string SCHEDULE_ALTERNATIVE_ATTR_SUFFIX = ":alternative";

const std::string FLAT_RANGE_FLATS_ATTR_SUFFIX = ":flats";
const std::string FLAT_RANGE_LEVELS_ATTR_SUFFIX = ":levels";

const std::string START_JUNCTION_ROLE = "start";
const std::string END_JUNCTION_ROLE = "end";
const std::string VIA_JUNCTION_ROLE = "via";
const std::string PLACED_AT_JUNCTION_ROLE = "placed_at";

const std::string FROM_RD_EL_ROLE = "from";
const std::string TO_RD_EL_ROLE = "to";
const std::string CONTROLLED_RD_EL_ROLE = "controlled";

const std::string PART_ROLE = "part";
const std::string CENTER_ROLE = "center";
const std::string CHILD_ROLE = "child";
const std::string AD_SUBST_CHILD_ROLE = "ad_subst_child";
const std::string SUBSTITUTION_ROLE = "substitution";
const std::string ASSOCIATED_WITH_ROLE = "associated_with";
const std::string ADDR_ASSOCIATED_WITH_ROLE = "addr_associated_with";
const std::string ADDR_ASSOCIATED_WITH_ZIPCODE_ROLE = "addr_associated_with_zipcode";
const std::string RD_ASSOCIATED_WITH_ROLE = "rd_associated_with";
const std::string ASSIGNED_ROLE = "assigned";
const std::string LN_PART_ROLE = "ln_part";
const std::string FC_PART_ROLE = "fc_part";
const std::string APPLIED_TO_ROLE = "applied_to";
const std::string BLD_ASSIGNED_ROLE = "bld_assigned";
const std::string URBAN_AREAL_ASSIGNED_ROLE = "urban_areal_assigned";
const std::string ENTRANCE_ASSIGNED_ROLE = "entrance_assigned";
const std::string ASSIGNED_THREAD_ROLE = "assigned_thread";
const std::string PARKING_LOT_LINEAR_ASSIGNED_ROLE = "parking_lot_linear_assigned";
const std::string ASSIGNED_AD_NEUTURAL_ROLE = "assigned_ad_neutral";
const std::string EXCLUSION_ROLE = "exclusion";
const std::string FLAT_RANGE_ASSIGNED_ROLE = "flat_range_assigned";
const std::string INDOOR_PLAN_ASSIGNED_ROLE = "indoor_plan_assigned";
const std::string ASSIGNED_INDOOR_RADIOMAP_CAPTURER_PATH_ROLE = "assigned_indoor_radiomap_capturer_path";
const std::string METRO_PART_ROLE = "metro_part";
const std::string BUS_PART_ROLE = "bus_part";
const std::string TRAM_PART_ROLE = "tram_part";
const std::string WATERWAY_PART_ROLE = "waterway_part";
const std::string ASSIGNED_ROAD_MARKING_POLYGONAL_ROLE = "assigned_road_marking_polygonal";
const std::string ASSIGNED_ROAD_MARKING_LINEAR_ROLE = "assigned_road_marking_linear";
const std::string ASSIGNED_ROAD_MARKING_POINT_LANE_DIRECTION_ROLE = "assigned_road_marking_point_lane_direction";
const std::string ASSIGNED_ROAD_MARKING_POINT_SYMBOL_ROLE = "assigned_road_marking_point_symbol";
const std::string ASSIGNED_ROAD_MARKING_POINT_ROAD_SIGN_ROLE = "assigned_road_marking_point_road_sign";
const std::string ASSIGNED_ROAD_MARKING_POINT_ROAD_SIGN_SPEED_LIMIT_ROLE = "assigned_road_marking_point_road_sign_speed_limit";
const std::string ASSIGNED_ROAD_MARKING_POINT_TEXT_ROLE = "assigned_road_marking_point_text";

const std::string PREVIOUS_ROLE = "previous";
const std::string STATION_A_ROLE = "station_a";
const std::string STATION_B_ROLE = "station_b";
const std::string ASSIGNED_THREAD_STOP_ROLE = "assigned_thread_stop";
const std::string STATION_ROLE = "station";
const std::string EXIT_ROLE = "exit";
const std::string ASSIGNED_METRO_ROLE = "assigned_metro";
const std::string ASSIGNED_WATERWAY_ROLE = "assigned_waterway";
const std::string ASSIGNED_TRAM_ROLE = "assigned_tram";
const std::string ASSIGNED_BUS_ROLE = "assigned_bus";
const std::string BOARDING_ROLE = "boarding";
const std::string STATION_PREVIOUS_ROLE = "station_previous";
const std::string STATION_NEXT_ROLE = "station_next";

const std::string OFFICIAL_NAME_ROLE = "official";
const std::string RENDER_LABEL_NAME_ROLE = "render_label";
const std::string ADDRESS_LABEL_NAME_ROLE = "address_label";
const std::string SHORT_NAME_ROLE = "short";
const std::string SYNONYM_NAME_ROLE = "synonym";
const std::string OLD_NAME_ROLE = "old";

const std::string RESTRICTS_ROLE = "restricts";
const std::string RESTRICTS_FROM_ROLE = "restricts_from";
const std::string RESTRICTS_TO_ROLE = "restricts_to";

const std::string ASSIGNED_INDOOR_AREA = "assigned_indoor_area";
const std::string ASSIGNED_INDOOR_POI_AUTO_ROLE = "assigned_indoor_poi_auto";
const std::string ASSIGNED_INDOOR_POI_EDU_ROLE = "assigned_indoor_poi_edu";
const std::string ASSIGNED_INDOOR_POI_FINANCE_ROLE = "assigned_indoor_poi_finance";
const std::string ASSIGNED_INDOOR_POI_FOOD_ROLE = "assigned_indoor_poi_food";
const std::string ASSIGNED_INDOOR_POI_GOVERMENT_ROLE = "assigned_indoor_poi_goverment";
const std::string ASSIGNED_INDOOR_POI_LEISURE_ROLE = "assigned_indoor_poi_leisure";
const std::string ASSIGNED_INDOOR_POI_MEDICINE_ROLE = "assigned_indoor_poi_medicine";
const std::string ASSIGNED_INDOOR_POI_RELIGION_ROLE = "assigned_indoor_poi_religion";
const std::string ASSIGNED_INDOOR_POI_SERVICE_ROLE = "assigned_indoor_poi_service";
const std::string ASSIGNED_INDOOR_POI_SHOPPING_ROLE = "assigned_indoor_poi_shopping";
const std::string ASSIGNED_INDOOR_POI_SPORT_ROLE = "assigned_indoor_poi_sport";

const std::string F_ZLEV_ATTR_SUFFIX = ":f_zlev";
const std::string T_ZLEV_ATTR_SUFFIX = ":t_zlev";
const std::string NAME_ATTR_SUFFIX = ":name";
const std::string LANG_ATTR_SUFFIX = ":lang";
const std::string IS_LOCAL_ATTR_SUFFIX = ":is_local";
const std::string IS_MAJOR_ATTR_SUFFIX = ":is_major";
const std::string DROPOFF_PICKUP_ATTR_SUFFIX = ":dropoff_pickup";
const std::string FT_TYPE_ATTR_SUFFIX = ":ft_type_id";
const std::string IS_INTERIOR_ATTR_SUFFIX = ":is_interior";
const std::string LEVEL_KIND_ATTR_SUFFIX = ":level_kind";
const std::string ISO_CODE_ATTR_SUFFIX = ":isocode";
const std::string TOWN_ATTR_SUFFIX = ":town";
const std::string INFORMAL_ATTR_SUFFIX = ":informal";
const std::string MUNICIPALITY_ATTR_SUFFIX = ":municipality";
const std::string RECOGNITION_ATTR_SUFFIX = ":recognition";
const std::string COND_TYPE_ATTR_SUFFIX = ":cond_type";
const std::string TYPE_ATTR_SUFFIX = ":type";
const std::string TIME_ATTR_SUFFIX = ":time";
const std::string TRAVEL_TIME_ATTR_SUFFIX = ":travel_time";
const std::string WAIT_TIME_ATTR_SUFFIX = ":wait_time";
const std::string FREQ_ATTR_SUFFIX = ":freq";
const std::string FC_ATTR_SUFFIX = ":fc";
const std::string FOW_ATTR_SUFFIX = ":fow";
const std::string STRUCT_TYPE_ATTR_SUFFIX = ":struct_type";
const std::string ONEWAY_ATTR_SUFFIX = ":oneway";
const std::string ACCESS_ID_ATTR_SUFFIX = ":access_id";
const std::string SPEED_LIMIT_ATTR_SUFFIX = ":speed_limit";
const std::string SPEED_LIMIT_T_ATTR_SUFFIX = ":speed_limit_t";
const std::string SPEED_LIMIT_TRUCK_ATTR_SUFFIX = ":speed_limit_truck";
const std::string SPEED_LIMIT_TRUCK_T_ATTR_SUFFIX = ":speed_limit_truck_t";
const std::string LANE_ATTR_SUFFIX = ":lane";
const std::string LANE_MIN_ATTR_SUFFIX = ":lane_min";
const std::string LANE_MAX_ATTR_SUFFIX = ":lane_max";
const std::string F_LANE_ATTR_SUFFIX = ":f_lane";
const std::string T_LANE_ATTR_SUFFIX = ":t_lane";
const std::string SKIP_VALIDATION_ATTR_SUFFIX = ":skip_validation";
const std::string SRV_UC_ATTR_SUFFIX = ":srv_uc";
const std::string SRV_UC_OPEN_AT_ATTR_SUFFIX = ":srv_uc_open_at";
const std::string PAVED_ATTR_SUFFIX = ":paved";
const std::string RESIDENTIAL_ATTR_SUFFIX = ":residential";
const std::string BACK_BUS_ATTR_SUFFIX = ":back_bus";
const std::string BACK_TAXI_ATTR_SUFFIX = ":back_taxi";
const std::string BACK_BICYCLE_ATTR_SUFFIX = ":back_bicycle";
const std::string DR_ATTR_SUFFIX = ":dr";
const std::string TOLL_ATTR_SUFFIX = ":toll";
const std::string BUSINESS_ID_ATTR_SUFFIX = ":business_id";
const std::string BUSINESS_RUBRIC_ID_ATTR_SUFFIX = ":business_rubric_id";
const std::string IS_GEOPRODUCT_ATTR_SUFFIX = ":is_geoproduct";
const std::string DEFAULT_ATTR_SUFFIX = ":default";
const std::string UNDERGROUND_ATTR_SUFFIX = ":underground";
const std::string UNIVERSAL_ATTR_SUFFIX = ":universal";
const std::string UNIVERSAL_ID_ATTR_SUFFIX = ":universal_id";
const std::string PASS_ID_ATTR_SUFFIX = ":pass_id";
const std::string NOT_OPERATING_ATTR_SUFFIX = ":not_operating";
const std::string POI_LOCATION_ATTR_SUFFIX = ":location";
const std::string POI_POSITION_QUALITY_ATTR_SUFFIX = ":position_quality";
const std::string BOARDING_OPTIONS_ATTR_SUFFIX = ":boarding_options";
const std::string TEMPORARY_ATTR_SUFFIX = ":temporary";
const std::string NO_SCOOTER_ACCESS_ATTR_SUFFIX = ":no_scooter_access";
const std::string NO_MOTO_ACCESS_ATTR_SUFFIX = ":no_moto_access";

const std::string IMPORT_SOURCE_ID_ATTR = "sys:import_source_id";
const std::string IMPORT_SOURCE_ATTR = "sys:import_source";
const std::string GEOBASE_ID = "sys:geobase_id";

const std::string POI_LOCATION_EMPTY = "";
const std::string POI_LOCATION_ENTRANCE_SIGN = "entrance_sign";
const std::string POI_LOCATION_INDOOR = "indoor";

const std::string POI_POSITION_QUALITY_EMPTY = "";
const std::string POI_POSITION_QUALITY_UNDEFINED = "undefined";
const std::string POI_POSITION_QUALITY_AUTO = "auto";
const std::string POI_POSITION_QUALITY_APPROXIMATE = "approximate";
const std::string POI_POSITION_QUALITY_USER = "user";
const std::string POI_POSITION_QUALITY_PRECISE = "precise";

const std::string BOARDING_OPTIONS_HEAD = "head";
const std::string BOARDING_OPTIONS_MIDDLE_HEAD = "middle_head";
const std::string BOARDING_OPTIONS_MIDDLE = "middle";
const std::string BOARDING_OPTIONS_MIDDLE_TAIL = "middle_tail";
const std::string BOARDING_OPTIONS_TAIL = "tail";

const std::string BASE_CHECK_ID = "base";

const std::string MESSAGE_MISSING_RELATED_OBJECT = "missing-related-object";
const std::string MESSAGE_DELETED_RELATED_OBJECT = "deleted-related-object";
const std::string MESSAGE_DUPLICATE_RELATION = "duplicate-relation";
const std::string MESSAGE_NO_ATTRIBUTES = "no-attributes";
const std::string MESSAGE_NO_GEOMETRY = "no-geometry";
const std::string MESSAGE_BAD_GEOMETRY = "bad-geometry";
const std::string MESSAGE_BAD_PARENT_RELATION = "bad-parent-relation";

const std::string CAT_PREFIX = "cat:";

const std::string RD_EL_CAT_NAME = "rd_el";
const std::string POI_ATTR_PREFIX = "poi";

const std::string FC_ATTR_NAME = RD_EL_CAT_NAME + FC_ATTR_SUFFIX;
const std::string ACCESS_ID_ATTR_NAME = RD_EL_CAT_NAME + ACCESS_ID_ATTR_SUFFIX;
const std::string ONEWAY_ATTR_NAME = RD_EL_CAT_NAME + ONEWAY_ATTR_SUFFIX;
const std::string FOW_ATTR_NAME = RD_EL_CAT_NAME + FOW_ATTR_SUFFIX;
const std::string STRUCT_TYPE_ATTR_NAME = RD_EL_CAT_NAME + STRUCT_TYPE_ATTR_SUFFIX;
const std::string SPEED_LIMIT_ATTR_NAME = RD_EL_CAT_NAME + SPEED_LIMIT_ATTR_SUFFIX;
const std::string F_ZLEV_ATTR_NAME = RD_EL_CAT_NAME + F_ZLEV_ATTR_SUFFIX;
const std::string T_ZLEV_ATTR_NAME = RD_EL_CAT_NAME + T_ZLEV_ATTR_SUFFIX;
const std::string BUSINESS_ID_ATTR_NAME = POI_ATTR_PREFIX + BUSINESS_ID_ATTR_SUFFIX;
const std::string BUSINESS_RUBRIC_ID_ATTR_NAME = POI_ATTR_PREFIX + BUSINESS_RUBRIC_ID_ATTR_SUFFIX;
const std::string ANNOTATION_ID_ATTR_NAME = "cond_annotation:annotation_id";
const std::string NO_GEOMETRY = "";

const std::string COLOR_ATTR_SUFFIX = ":color";
const std::string DIRECTION_ATTR_SUFFIX = ":direction";
const std::string ICON_ATTR_SUFFIX = ":icon";
const std::string NEW_LINE_ATTR_SUFFIX = ":new_line";
const std::string ORDER_ATTR_SUFFIX = ":order";

const std::string ASSIGNED_COND_DS_EL_ROLE = "assigned_cond_ds_el";

const std::string ASSIGNED_AD_ROLE = "assigned_ad";
const std::string ASSIGNED_RD_ROLE = "assigned_rd";
const std::string ADDR_UNITY_ATTR_SUFFIX = ":addr_unity";

} // namespace validator
} // namespace wiki
} // namespace maps
