#pragma once

#include "magic_strings.h"
#include <yandex/maps/wiki/validator/objects/name.h>

#include <map>

namespace maps {
namespace wiki {
namespace validator {

const std::map<std::string, NameRelation::Type> ROLE_TO_NAME_RELATION_TYPE = {
    {OFFICIAL_NAME_ROLE, NameRelation::Type::Official},
    {RENDER_LABEL_NAME_ROLE, NameRelation::Type::RenderLabel},
    {ADDRESS_LABEL_NAME_ROLE, NameRelation::Type::AddressLabel},
    {SHORT_NAME_ROLE, NameRelation::Type::Short},
    {SYNONYM_NAME_ROLE, NameRelation::Type::Synonym},
    {OLD_NAME_ROLE, NameRelation::Type::Old},
};

} // namespace validator
} // namespace wiki
} // namespace maps
