#pragma once

#include <yandex/maps/wiki/validator/content/geom_objects_view.h>

#include "index_suites.h"

#include <functional>

namespace maps {
namespace wiki {

class ThreadPool;

namespace validator {

template<class Object>
class GeomObjectsView<Object>::Impl
{
public:
    typedef typename ObjectIndexSuiteType<Object>::type TIndexSuite;

    Impl(
        const TIndexSuite& indexSuite,
        CheckContext& context,
        ThreadPool& pool)
        : indexSuite_(indexSuite)
        , context_(context)
        , pool_(pool)
    { }

    const typename TIndexSuite::ByIdIndex& objectIdIndex() const
    { return indexSuite_.byId(); }

    const typename TIndexSuite::SpatialIndex& spatialIndex() const
    { return indexSuite_.spatial(); }

    void visit(std::function<void(const Object*)> visitor) const
    { indexSuite_.byId().visit(visitor, context_); }

    void batchVisit(
        std::function<void(const Object*)> visitor,
        size_t batchSize) const
    { indexSuite_.byId().batchVisit(visitor, batchSize, context_, pool_); }

    void batchVisitObjects(
            const std::vector<const Object*>& objects,
            std::function<void(const Object*)> visitor,
            size_t batchSize) const
    { batchVisitVec(objects, visitor, batchSize, context_, pool_); }

private:
    const TIndexSuite& indexSuite_;
    CheckContext& context_;
    ThreadPool& pool_;
};

} // namespace validator
} // namespace wiki
} // namespace maps
