#pragma once

#include "object_id_index.h"
#include <yandex/maps/wiki/validator/has_geom.h>

#include <maps/libs/geolib/include/static_geometry_searcher.h>

#include <vector>

namespace maps {
namespace wiki {
namespace validator {

template<class TObject>
class SimpleIndexSuite
{
public:
    typedef ObjectIdIndex<TObject> ByIdIndex;

    template <typename TObjects>
    SimpleIndexSuite(const TObjects& objects)
        : byId_(objects)
    { }

    virtual ~SimpleIndexSuite()
    { }

    const ByIdIndex& byId() const
    { return byId_; }

private:
    ByIdIndex byId_;
};

template<class TObject>
class GeomIndexSuite : public SimpleIndexSuite<TObject>
{
public:
    typedef geolib3::StaticGeometrySearcher<
        typename TObject::TGeom, const TObject*> SpatialIndex;

    template <typename TObjects>
    GeomIndexSuite(const TObjects& objects)
        : SimpleIndexSuite<TObject>(objects)
    {
        for (const auto& object : objects) {
            spatial_.insert(&object.geom(), &object);
        }
        spatial_.build();
    }

    virtual ~GeomIndexSuite()
    { }

    const SpatialIndex& spatial() const
    { return spatial_; }

private:
    SpatialIndex spatial_;
};

template<class TObject>
struct ObjectIndexSuiteType
{
    typedef typename boost::mpl::if_<
        HasGeom<TObject>,
        GeomIndexSuite<TObject>,
        SimpleIndexSuite<TObject>>::type type;
};

} // namespace validator
} // namespace wiki
} // namespace maps
