#pragma once

#include "objects_collection_base.h"
#include "geom_objects_view_impl.h"
#include "objects_view_impl.h"

#include <yandex/maps/wiki/configs/editor/fwd.h>
#include <deque>


namespace maps {
namespace wiki {

class ThreadPool;

namespace validator {

class ObjectLoadingException;

template<class Category>
class InMemoryObjectsCollection : public ObjectsCollectionBase
{
public:
    typedef typename Category::TObject TObject;
    typedef typename CategoryObjectConstructor<Category>::type TObjectConstructor;
    typedef typename Category::TObjectsView TObjectsView;
    typedef typename ObjectIndexSuiteType<TObject>::type TIndexSuite;

    InMemoryObjectsCollection();

    TObjectsView view(CheckContext& context, ThreadPool& pool) const
    {
        return createView<TObjectsView>(*indexSuite_, context, pool);
    }

    std::vector<TId> objectIds() const override;
    boost::optional<RevisionID> revisionId(TId oid) const override;

    void addRevisions(
        std::vector<ObjectDatum> objectData,
        ObjectIdToCommitId objectCommitIds,
        ObjectIdSet deletedRelatedObjectIds,
        const AreaOfInterest& aoi,
        const configs::editor::Category* configCategory,
        const ImportantRegions& importantRegions,
        std::list<Message>* baseCheckMessages) override;

    size_t finalize() override;
    void unload() override;

private:
    using TObjects = std::deque<TObject>;

    TObjects objects_;
    size_t constructorFailsCount_;
    ObjectIdToCommitId objectIdToCommitId_;
    std::unique_ptr<TIndexSuite> indexSuite_;
};

} // namespace validator
} // namespace wiki
} // namespace maps
