#pragma once

#include <maps/wikimap/mapspro/libs/validator/loader/db_gateway.h>
#include <maps/wikimap/mapspro/libs/validator/loader/object_constructors.h>
#include <maps/wikimap/mapspro/libs/validator/loader/important_regions.h>

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/message.h>

#include <yandex/maps/wiki/configs/editor/fwd.h>

#include <boost/optional.hpp>

#include <atomic>
#include <memory>
#include <vector>

namespace maps {
namespace wiki {
namespace validator {

class ObjectLoadingException;

class ObjectsCollectionBase
{
public:
    ObjectsCollectionBase(TCategoryId categoryId)
        : categoryId_(std::move(categoryId))
        , loaded_(false)
    { }

    virtual ~ObjectsCollectionBase()
    { }

    void checkLoaded() const
    { REQUIRE(loaded_.load(), "category " << categoryId_ << " not loaded"); }

    virtual std::vector<TId> objectIds() const = 0;

    // returns nonempty id if object is in collection or is related to
    // objects in collection
    virtual boost::optional<RevisionID> revisionId(TId oid) const = 0;

    virtual void addRevisions(
            std::vector<ObjectDatum> objectData,
            ObjectIdToCommitId objectCommitIds,
            ObjectIdSet deletedRelatedObjectIds,
            const AreaOfInterest& aoi,
            const configs::editor::Category* configCategory,
            const ImportantRegions& importantRegions,
            std::list<Message>* baseCheckErrors) = 0;

    // returns size of collection
    virtual size_t finalize() = 0;

    virtual void unload() = 0;

protected:
    template<class TObjectsView, class... Args>
    TObjectsView createView(Args&&... args) const
    {
        using ViewImpl = typename TObjectsView::Impl;

        checkLoaded();
        return TObjectsView(new ViewImpl(std::forward<Args>(args)...));
    }

    TCategoryId categoryId_;
    std::atomic_bool loaded_;
};

} // namespace validator
} // namespace wiki
} // namespace maps
