#include "objects_collections_tuple.h"

namespace maps {
namespace wiki {
namespace validator {

namespace {

template<typename Category>
ObjectsCollectionsMap::value_type nameCollPair(
        ObjectsCollectionsTuple& collectionsTuple)
{
    std::reference_wrapper<ObjectsCollectionBase> ref(
            castToCollection<Category>(collectionsTuple));
    return { Category::id(), ref };
}

template<typename TypeList> struct InitCollectionsMap;

template<typename... Categories>
struct InitCollectionsMap<TypeList<Categories...>>
{
    InitCollectionsMap(
            ObjectsCollectionsTuple& collectionsTuple,
            ObjectsCollectionsMap* collectionsMap)
    {
        collectionsMap->insert({nameCollPair<Categories>(collectionsTuple)...});
    }
};

} // namespace

ObjectsCollectionsMap
collectionsTupleToCollectionsMap(ObjectsCollectionsTuple& tuple)
{
    ObjectsCollectionsMap result;
    InitCollectionsMap<CategoriesList>(tuple, &result);
    return result;
}

} // namespace validator
} // namespace wiki
} // namespace maps
