#include "objects_view_impl.h"

#include <yandex/maps/wiki/validator/objects/adm_unit.h>
#include <yandex/maps/wiki/validator/objects/adm_unit_subst.h>
#include <yandex/maps/wiki/validator/objects/building_complex.h>
#include <yandex/maps/wiki/validator/objects/condition.h>
#include <yandex/maps/wiki/validator/objects/condition_lane.h>
#include <yandex/maps/wiki/validator/objects/cond_annotation.h>
#include <yandex/maps/wiki/validator/objects/cond_ds.h>
#include <yandex/maps/wiki/validator/objects/cond_ds_el.h>
#include <yandex/maps/wiki/validator/objects/cond_toll.h>
#include <yandex/maps/wiki/validator/objects/contour_feature.h>
#include <yandex/maps/wiki/validator/objects/contour_linear_feature.h>
#include <yandex/maps/wiki/validator/objects/face.h>
#include <yandex/maps/wiki/validator/objects/flat_range.h>
#include <yandex/maps/wiki/validator/objects/linear_feature.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <yandex/maps/wiki/validator/objects/point_feature.h>
#include <yandex/maps/wiki/validator/objects/road.h>
#include <yandex/maps/wiki/validator/objects/schedule.h>
#include <yandex/maps/wiki/validator/objects/traffic_light.h>
#include <yandex/maps/wiki/validator/objects/transport_boarding.h>
#include <yandex/maps/wiki/validator/objects/transport_line.h>
#include <yandex/maps/wiki/validator/objects/transport_metro_exit.h>
#include <yandex/maps/wiki/validator/objects/transport_metro_station.h>
#include <yandex/maps/wiki/validator/objects/transport_passageway.h>
#include <yandex/maps/wiki/validator/objects/transport_thread.h>
#include <yandex/maps/wiki/validator/objects/transport_thread_stop.h>
#include <yandex/maps/wiki/validator/objects/transport_transition.h>
#include <yandex/maps/wiki/validator/objects/vehicle_restriction.h>

namespace maps {
namespace wiki {
namespace validator {

template<class Object>
ObjectsView<Object>::ObjectsView(ObjectsView<Object>::Impl* impl)
    : impl_(impl)
{ }

template<class Object>
ObjectsView<Object>::~ObjectsView() = default;

template<class Object>
void ObjectsView<Object>::visit(
        std::function<void(const Object*)> visitor) const
{ impl_->visit(visitor); }

template<class Object>
void ObjectsView<Object>::batchVisit(
        std::function<void(const Object*)> visitor,
        size_t batchSize) const
{ impl_->batchVisit(visitor, batchSize); }

template<class Object>
void ObjectsView<Object>::batchVisitObjects(
        const std::vector<const Object*>& objects,
        std::function<void(const Object*)> visitor,
        size_t batchSize) const
{ impl_->batchVisitObjects(objects, visitor, batchSize); }

template<class Object>
bool ObjectsView<Object>::loaded(TId id) const
{ return impl_->objectIdIndex().contains(id); }

template<class Object>
const Object* ObjectsView<Object>::byId(TId id) const
{ return impl_->objectIdIndex().byId(id); }


template class ObjectsView<BuildingComplex>;
template class ObjectsView<Condition>;
template class ObjectsView<ConditionLane>;
template class ObjectsView<CondAnnotation>;
template class ObjectsView<CondDirectionSign>;
template class ObjectsView<CondDirectionSignElement>;
template class ObjectsView<CondToll>;
template class ObjectsView<TrafficLight>;
template class ObjectsView<Schedule>;
template class ObjectsView<Road>;
template class ObjectsView<Face>;
template class ObjectsView<FlatRange>;
template class ObjectsView<AdmUnit>;
template class ObjectsView<AdmUnitSubst>;
template class ObjectsView<Name>;
template class ObjectsView<PointFeature>;
template class ObjectsView<LinearFeature>;
template class ObjectsView<ContourFeature>;
template class ObjectsView<ContourLinearFeature>;
template class ObjectsView<TransportMetroExit>;
template class ObjectsView<TransportMetroStation>;
template class ObjectsView<TransportThread>;
template class ObjectsView<TransportThreadStop>;
template class ObjectsView<TransportTransition>;
template class ObjectsView<TransportPassageway>;
template class ObjectsView<TransportTransitionBoarding>;
template class ObjectsView<TransportPassagewayBoarding>;
template class ObjectsView<TransportLine>;
template class ObjectsView<VehicleRestriction>;

} // namespace validator
} // namespace wiki
} // namespace maps
