#pragma once

#ifndef YANDEX_MAPS_WIKI_VALIDATOR_AREA_OF_INTEREST_INL
#error "Direct inclusion of area_of_interest_inl.h is not allowed, \
    please include area_of_interest.h instead"
#endif // YANDEX_MAPS_WIKI_VALIDATOR_AREA_OF_INTEREST_INL

namespace maps {
namespace wiki {
namespace validator {

const DBID DBID_USER_AOI = 0;

const std::string LAYER_INCLUDED_PRIMARY_ORIGINAL = "included_primary_original";
const std::string LAYER_INCLUDED_PRIMARY_BUFFERED = "included_primary_buffered";
const std::string LAYER_EXCLUDED_ORIGINAL = "excluded_original";
const std::string LAYER_EXCLUDED_BUFFERED = "excluded_buffered";
const std::string LAYER_INCLUDED_SECONDARY_ORIGINAL = "included_secondary_original";
const std::string LAYER_INCLUDED_SECONDARY_BUFFERED = "included_secondary_buffered";

enum class Importance
{
    Primary,
    Secondary
};

enum class IntersectionMode
{
    Any,
    All
};

template<typename TGeom>
bool intersectsWithGeomPoints(
    const TGeom&,
    IntersectionMode,
    std::function<bool(const geolib3::Point2&)>)
{
    REQUIRE(false, "Invalid geometry type");
}

template<>
inline bool intersectsWithGeomPoints<geolib3::Point2>(
    const geolib3::Point2& geom,
    IntersectionMode,
    std::function<bool(const geolib3::Point2&)> checker)
{
    return checker(geom);
}

template<>
inline bool intersectsWithGeomPoints<geolib3::Polyline2>(
    const geolib3::Polyline2& geom,
    IntersectionMode mode,
    std::function<bool(const geolib3::Point2&)> checker)
{
    for (const auto& point : geom.points()) {
        switch (mode) {
            case IntersectionMode::Any: {
                if (checker(point)) {
                    return true;
                }
                break;
            }
            case IntersectionMode::All: {
                if (!checker(point)) {
                    return false;
                }
                break;
            }
        }
    }
    return mode == IntersectionMode::All;
}

template<>
inline bool intersectsWithGeomPoints<geolib3::Polygon2>(
    const geolib3::Polygon2& geom,
    IntersectionMode mode,
    std::function<bool(const geolib3::Point2&)> checker)
{
    const auto& exteriorRing = geom.exteriorRing();
    for (size_t i = 0; i < exteriorRing.pointsNumber(); ++i) {
        switch (mode) {
            case IntersectionMode::Any: {
                if (checker(exteriorRing.pointAt(i))) {
                    return true;
                }
                break;
            }
            case IntersectionMode::All: {
                if (!checker(exteriorRing.pointAt(i))) {
                    return false;
                }
                break;
            }
        }
    }
    return mode == IntersectionMode::All;
}

} // namespace validator
} // namespace wiki
} // namespace maps
