#pragma once

#include <yandex/maps/wiki/validator/content/geom_objects_view.h>
#include <yandex/maps/wiki/validator/content/objects_view.h>

#include <yandex/maps/wiki/validator/objects/address_point.h>
#include <yandex/maps/wiki/validator/objects/arrival_point.h>
#include <yandex/maps/wiki/validator/objects/adm_unit.h>
#include <yandex/maps/wiki/validator/objects/adm_unit_subst.h>
#include <yandex/maps/wiki/validator/objects/building.h>
#include <yandex/maps/wiki/validator/objects/building_complex.h>
#include <yandex/maps/wiki/validator/objects/center.h>
#include <yandex/maps/wiki/validator/objects/cond_annotation.h>
#include <yandex/maps/wiki/validator/objects/cond_toll.h>
#include <yandex/maps/wiki/validator/objects/condition.h>
#include <yandex/maps/wiki/validator/objects/condition_lane.h>
#include <yandex/maps/wiki/validator/objects/cond_ds.h>
#include <yandex/maps/wiki/validator/objects/cond_ds_el.h>
#include <yandex/maps/wiki/validator/objects/contour_feature.h>
#include <yandex/maps/wiki/validator/objects/contour_linear_feature.h>
#include <yandex/maps/wiki/validator/objects/edge.h>
#include <yandex/maps/wiki/validator/objects/face.h>
#include <yandex/maps/wiki/validator/objects/flat_range.h>
#include <yandex/maps/wiki/validator/objects/indoor_level.h>
#include <yandex/maps/wiki/validator/objects/indoor_plan.h>
#include <yandex/maps/wiki/validator/objects/junction.h>
#include <yandex/maps/wiki/validator/objects/linear_feature.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <yandex/maps/wiki/validator/objects/parking_controlled_zone.h>
#include <yandex/maps/wiki/validator/objects/parking_lot.h>
#include <yandex/maps/wiki/validator/objects/polyline_feature.h>
#include <yandex/maps/wiki/validator/objects/poi.h>
#include <yandex/maps/wiki/validator/objects/poi_entrance.h>
#include <yandex/maps/wiki/validator/objects/point_feature.h>
#include <yandex/maps/wiki/validator/objects/polygon_feature.h>
#include <yandex/maps/wiki/validator/objects/region.h>
#include <yandex/maps/wiki/validator/objects/road.h>
#include <yandex/maps/wiki/validator/objects/road_element.h>
#include <yandex/maps/wiki/validator/objects/road_marking_linear.h>
#include <yandex/maps/wiki/validator/objects/road_marking_point.h>
#include <yandex/maps/wiki/validator/objects/road_marking_polygonal.h>
#include <yandex/maps/wiki/validator/objects/road_surface.h>
#include <yandex/maps/wiki/validator/objects/schedule.h>
#include <yandex/maps/wiki/validator/objects/service_polygon.h>
#include <yandex/maps/wiki/validator/objects/traffic_light.h>
#include <yandex/maps/wiki/validator/objects/transport_airport.h>
#include <yandex/maps/wiki/validator/objects/transport_boarding.h>
#include <yandex/maps/wiki/validator/objects/transport_element.h>
#include <yandex/maps/wiki/validator/objects/transport_line.h>
#include <yandex/maps/wiki/validator/objects/transport_metro_exit.h>
#include <yandex/maps/wiki/validator/objects/transport_metro_station.h>
#include <yandex/maps/wiki/validator/objects/transport_operator.h>
#include <yandex/maps/wiki/validator/objects/transport_passageway.h>
#include <yandex/maps/wiki/validator/objects/transport_stop.h>
#include <yandex/maps/wiki/validator/objects/transport_thread.h>
#include <yandex/maps/wiki/validator/objects/transport_thread_stop.h>
#include <yandex/maps/wiki/validator/objects/transport_transition.h>
#include <yandex/maps/wiki/validator/objects/vehicle_restriction.h>

#include <string>

namespace maps::wiki::validator {

namespace categories {

// Road graph

struct RD_EL
{
    static TCategoryId id() { return "rd_el"; }
    typedef RoadElement TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct RD
{
    static TCategoryId id() { return "rd"; }
    typedef Road TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct RD_JC
{
    static TCategoryId id() { return "rd_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct RD_NM
{
    static TCategoryId id() { return "rd_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct COND
{
    static TCategoryId id() { return "cond"; }
    typedef Condition TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct COND_ANNOTATION
{
    static TCategoryId id() { return "cond_annotation"; }
    typedef CondAnnotation TObject;
    typedef ObjectsView<TObject> TObjectsView;
};


struct COND_CAM
{
    static TCategoryId id() { return "cond_cam"; }
    typedef Condition TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct COND_TRAFFIC_LIGHT
{
    static TCategoryId id() { return "cond_traffic_light"; }
    typedef TrafficLight TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct COND_LANE
{
    static TCategoryId id() { return "cond_lane"; }
    typedef ConditionLane TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct COND_TOLL
{
    static TCategoryId id() { return "cond_toll"; }
    typedef CondToll TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct COND_DS
{
    static TCategoryId id() { return "cond_ds"; }
    typedef CondDirectionSign TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct COND_DS_EL
{
    static TCategoryId id() { return "cond_ds_el"; }
    typedef CondDirectionSignElement TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct COND_DT
{
    static TCategoryId id() { return "cond_dt"; }
    typedef Schedule TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct FREQ_DT
{
    static TCategoryId id() { return "freq_dt"; }
    typedef Schedule TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// Administrative division

struct AD_EL
{
    static TCategoryId id() { return "ad_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct AD_JC
{
    static TCategoryId id() { return "ad_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct AD_FC
{
    static TCategoryId id() { return "ad_fc"; }
    typedef Face TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct AD_CNT
{
    static TCategoryId id() { return "ad_cnt"; }
    typedef Center TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct AD
{
    static TCategoryId id() { return "ad"; }
    typedef AdmUnit TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct AD_NM
{
    static TCategoryId id() { return "ad_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct AD_SUBST_FC
{
    static TCategoryId id() { return "ad_subst_fc"; }
    typedef Face TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct AD_SUBST
{
    static TCategoryId id() { return "ad_subst"; }
    typedef AdmUnitSubst TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// Addressing

struct ADDR
{
    static TCategoryId id() { return "addr"; }
    typedef AddressPoint TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ADDR_NM
{
    static TCategoryId id() { return "addr_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct ZIPCODE
{
    static TCategoryId id() { return "zipcode"; }
    typedef PointFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ZIPCODE_NM
{
    static TCategoryId id() { return "zipcode_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct ARRIVAL_POINT
{
    static TCategoryId id() { return "arrival_point"; }
    typedef ArrivalPoint TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ARRIVAL_POINT_NM
{
    static TCategoryId id() { return "arrival_point_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct FLAT_RANGE
{
    static TCategoryId id() { return "flat_range"; }
    typedef FlatRange TObject;
    typedef ObjectsView<FlatRange> TObjectsView;
};

// Features

struct BLD
{
    static TCategoryId id() { return "bld"; }
    typedef Building TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct BLD_COMPLEX
{
    static TCategoryId id() { return "bld_complex"; }
    typedef BuildingComplex TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// transport_metro

struct TRANSPORT_METRO_LINE
{
    static TCategoryId id() { return "transport_metro_line"; }
    typedef TransportLine TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_METRO_STATION
{
    static TCategoryId id() { return "transport_metro_station"; }
    typedef TransportMetroStation TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_METRO_EXIT
{
    static TCategoryId id() { return "transport_metro_exit"; }
    typedef TransportMetroExit TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_METRO_EL
{
    static TCategoryId id() { return "transport_metro_el"; }
    typedef TransportElement TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_METRO_JC
{
    static TCategoryId id() { return "transport_metro_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_METRO_NM
{
    static TCategoryId id() { return "transport_metro_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// mass_transit
struct TRANSPORT_OPERATOR
{
    static TCategoryId id() { return "transport_operator"; }
    typedef TransportOperator TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_METRO_THREAD
{
    static TCategoryId id() { return "transport_metro_thread"; }
    typedef TransportThread TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_TRAM_THREAD
{
    static TCategoryId id() { return "transport_tram_thread"; }
    typedef TransportThread TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_WATERWAY_THREAD
{
    static TCategoryId id() { return "transport_waterway_thread"; }
    typedef TransportThread TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_BUS_THREAD
{
    static TCategoryId id() { return "transport_bus_thread"; }
    typedef TransportThread TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_BUS_ROUTE
{
    static TCategoryId id() { return "transport_bus_route"; }
    typedef TransportLine TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_THREAD_STOP
{
    static TCategoryId id() { return "transport_thread_stop"; }
    typedef TransportThreadStop TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_TRANSITION
{
    static TCategoryId id() { return "transport_transition"; }
    typedef TransportTransition TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_PASSAGEWAY
{
    static TCategoryId id() { return "transport_passageway"; }
    typedef TransportPassageway TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_TRANSITION_BOARDING
{
    static TCategoryId id() { return "transport_transition_boarding"; }
    typedef TransportTransitionBoarding TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_PASSAGEWAY_BOARDING
{
    static TCategoryId id() { return "transport_passageway_boarding"; }
    typedef TransportPassagewayBoarding TObject;
    typedef ObjectsView<TObject> TObjectsView;
};


// transport_railway

struct TRANSPORT_RAILWAY
{
    static TCategoryId id() { return "transport_railway"; }
    typedef LinearFeature TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_RAILWAY_STATION
{
    static TCategoryId id() { return "transport_railway_station"; }
    typedef PointFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_RAILWAY_PLATFORM
{
    static TCategoryId id() { return "transport_railway_platform"; }
    typedef PolygonFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_RAILWAY_EL
{
    static TCategoryId id() { return "transport_railway_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_RAILWAY_JC
{
    static TCategoryId id() { return "transport_railway_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_RAILWAY_NM
{
    static TCategoryId id() { return "transport_railway_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// transport

struct TRANSPORT_TRAM_ROUTE
{
    static TCategoryId id() { return "transport_tram_route"; }
    typedef TransportLine TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_STOP
{
    static TCategoryId id() { return "transport_stop"; }
    typedef TransportStop TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_TERMINAL
{
    static TCategoryId id() { return "transport_terminal"; }
    typedef PointFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_TRAM_EL
{
    static TCategoryId id() { return "transport_tram_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_TRAM_JC
{
    static TCategoryId id() { return "transport_tram_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_NM
{
    static TCategoryId id() { return "transport_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// transport_airport

struct TRANSPORT_AIRPORT
{
    static TCategoryId id() { return "transport_airport"; }
    typedef TransportAirport TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_AIRPORT_TERMINAL
{
    static TCategoryId id() { return "transport_airport_terminal"; }
    typedef PointFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_HELICOPTER
{
    static TCategoryId id() { return "transport_helicopter"; }
    typedef PointFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_AIRPORT_NM
{
    static TCategoryId id() { return "transport_airport_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// transport_waterway_route

struct TRANSPORT_WATERWAY_ROUTE
{
    static TCategoryId id() { return "transport_waterway_route"; }
    typedef TransportLine TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_WATERWAY_STOP
{
    static TCategoryId id() { return "transport_waterway_stop"; }
    typedef TransportStop TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_WATERWAY_EL
{
    static TCategoryId id() { return "transport_waterway_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_WATERWAY_JC
{
    static TCategoryId id() { return "transport_waterway_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct TRANSPORT_WATERWAY_NM
{
    static TCategoryId id() { return "transport_waterway_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// vegetation

struct VEGETATION
{
    static TCategoryId id() { return "vegetation"; }
    typedef ContourFeature TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct VEGETATION_CNT
{
    static TCategoryId id() { return "vegetation_cnt"; }
    typedef Center TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct VEGETATION_FC
{
    static TCategoryId id() { return "vegetation_fc"; }
    typedef Face TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct VEGETATION_EL
{
    static TCategoryId id() { return "vegetation_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct VEGETATION_JC
{
    static TCategoryId id() { return "vegetation_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct VEGETATION_NM
{
    static TCategoryId id() { return "vegetation_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// hydro

struct HYDRO
{
    static TCategoryId id() { return "hydro"; }
    typedef ContourFeature TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct HYDRO_FC
{
    static TCategoryId id() { return "hydro_fc"; }
    typedef Face TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct HYDRO_FC_EL
{
    static TCategoryId id() { return "hydro_fc_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct HYDRO_FC_JC
{
    static TCategoryId id() { return "hydro_fc_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct HYDRO_LN
{
    static TCategoryId id() { return "hydro_ln"; }
    typedef LinearFeature TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct HYDRO_LN_EL
{
    static TCategoryId id() { return "hydro_ln_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct HYDRO_LN_JC
{
    static TCategoryId id() { return "hydro_ln_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct HYDRO_POINT
{
    static TCategoryId id() { return "hydro_point"; }
    typedef PointFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct HYDRO_NM
{
    static TCategoryId id() { return "hydro_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// urban

struct URBAN
{
    static TCategoryId id() { return "urban"; }
    typedef ContourFeature TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct URBAN_FC
{
    static TCategoryId id() { return "urban_fc"; }
    typedef Face TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct URBAN_EL
{
    static TCategoryId id() { return "urban_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct URBAN_JC
{
    static TCategoryId id() { return "urban_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct URBAN_NM
{
    static TCategoryId id() { return "urban_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct URBAN_AREAL
{
    static TCategoryId id() { return "urban_areal"; }
    typedef PolygonFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

// urban_roadnet

struct URBAN_ROADNET
{
    static TCategoryId id() { return "urban_roadnet"; }
    typedef ContourFeature TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct URBAN_ROADNET_FC
{
    static TCategoryId id() { return "urban_roadnet_fc"; }
    typedef Face TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct URBAN_ROADNET_EL
{
    static TCategoryId id() { return "urban_roadnet_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct URBAN_ROADNET_JC
{
    static TCategoryId id() { return "urban_roadnet_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct URBAN_ROADNET_AREAL
{
    static TCategoryId id() { return "urban_roadnet_areal"; }
    typedef PolygonFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct URBAN_ROADNET_PARKING_LOT
{
    static TCategoryId id() { return "urban_roadnet_parking_lot"; }
    typedef ParkingLot TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct URBAN_ROADNET_PARKING_LOT_LINEAR
{
    static TCategoryId id() { return "urban_roadnet_parking_lot_linear"; }
    typedef PolylineFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct URBAN_ROADNET_PARKING_CONTROLLED_ZONE
{
    static TCategoryId id() { return "urban_roadnet_parking_controlled_zone"; }
    typedef ParkingControlledZone TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct URBAN_ROADNET_NM
{
    static TCategoryId id() { return "urban_roadnet_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// relief

struct RELIEF
{
    static TCategoryId id() { return "relief"; }
    typedef ContourFeature TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct RELIEF_POINT
{
    static TCategoryId id() { return "relief_point"; }
    typedef PointFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct RELIEF_FC
{
    static TCategoryId id() { return "relief_fc"; }
    typedef Face TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct RELIEF_EL
{
    static TCategoryId id() { return "relief_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct RELIEF_JC
{
    static TCategoryId id() { return "relief_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct RELIEF_NM
{
    static TCategoryId id() { return "relief_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// POI

struct POI_MEDICINE
{
    static TCategoryId id() { return "poi_medicine"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_EDU
{
    static TCategoryId id() { return "poi_edu"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_FINANCE
{
    static TCategoryId id() { return "poi_finance"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_SHOPPING
{
    static TCategoryId id() { return "poi_shopping"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_GOVERMENT
{
    static TCategoryId id() { return "poi_goverment"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_RELIGION
{
    static TCategoryId id() { return "poi_religion"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_FOOD
{
    static TCategoryId id() { return "poi_food"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_AUTO
{
    static TCategoryId id() { return "poi_auto"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_SPORT
{
    static TCategoryId id() { return "poi_sport"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_LEISURE
{
    static TCategoryId id() { return "poi_leisure"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_URBAN
{
    static TCategoryId id() { return "poi_urban"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_SERVICE
{
    static TCategoryId id() { return "poi_service"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_OTHER
{
    static TCategoryId id() { return "poi_other"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct POI_NM
{
    static TCategoryId id() { return "poi_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// Indoor plan and level

struct INDOOR_PLAN
{
    static TCategoryId id() { return "indoor_plan"; }
    typedef IndoorPlan TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_LEVEL
{
    static TCategoryId id() { return "indoor_level"; }
    typedef IndoorLevel TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_AREA
{
    static TCategoryId id() { return "indoor_area"; }
    typedef PolygonFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_NM
{
    static TCategoryId id() { return "indoor_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

// Indoor POI

struct INDOOR_POI_AUTO
{
    static TCategoryId id() { return "indoor_poi_auto"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_FOOD
{
    static TCategoryId id() { return "indoor_poi_food"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_SHOPPING
{
    static TCategoryId id() { return "indoor_poi_shopping"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_RELIGION
{
    static TCategoryId id() { return "indoor_poi_religion"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};


struct INDOOR_POI_SERVICE
{
    static TCategoryId id() { return "indoor_poi_service"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_FINANCE
{
    static TCategoryId id() { return "indoor_poi_finance"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_MEDICINE
{
    static TCategoryId id() { return "indoor_poi_medicine"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_EDU
{
    static TCategoryId id() { return "indoor_poi_edu"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_LEISURE
{
    static TCategoryId id() { return "indoor_poi_leisure"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_SPORT
{
    static TCategoryId id() { return "indoor_poi_sport"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_GOVERMENT
{
    static TCategoryId id() { return "indoor_poi_goverment"; }
    typedef Poi TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_POI_NM
{
    static TCategoryId id() { return "indoor_poi_nm"; }
    typedef Name TObject;
    typedef ObjectsView<TObject> TObjectsView;
};



// Poi Entrance

struct POI_ENTRANCE
{
    static TCategoryId id() { return "poi_entrance"; }
    typedef PoiEntrance TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

// Ad neutral

struct AD_NEUTRAL
{
    static TCategoryId id() { return "ad_neutral"; }
    typedef ContourFeature TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct AD_NEUTRAL_FC
{
    static TCategoryId id() { return "ad_neutral_fc"; }
    typedef Face TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct AD_NEUTRAL_EL
{
    static TCategoryId id() { return "ad_neutral_el"; }
    typedef Edge TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct AD_NEUTRAL_JC
{
    static TCategoryId id() { return "ad_neutral_jc"; }
    typedef Junction TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct REGION
{
    static TCategoryId id() { return "region"; }
    typedef Region TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct VEHICLE_RESTRICTION
{
    static TCategoryId id() { return "vehicle_restriction"; }
    typedef VehicleRestriction TObject;
    typedef ObjectsView<TObject> TObjectsView;
};

struct MRC_PEDESTRIAN_REGION
{
    static TCategoryId id() { return "mrc_pedestrian_region"; }
    typedef ServicePolygon TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct INDOOR_RADIOMAP_CAPTURER_PATH
{
    static TCategoryId id() { return "indoor_radiomap_capturer_path"; }
    typedef PolylineFeature TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ROAD_SURFACE
{
    static TCategoryId id() { return "road_surface"; }
    typedef RoadSurface TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ROAD_MARKING_POLYGONAL
{
    static TCategoryId id() { return "road_marking_polygonal"; }
    typedef RoadMarkingPolygonal TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ROAD_MARKING_LINEAR
{
    static TCategoryId id() { return "road_marking_linear"; }
    typedef RoadMarkingLinear TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ROAD_MARKING_POINT_LANE_DIRECTION
{
    static TCategoryId id() { return "road_marking_point_lane_direction"; }
    typedef RoadMarkingPoint TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ROAD_MARKING_POINT_SYMBOL
{
    static TCategoryId id() { return "road_marking_point_symbol"; }
    typedef RoadMarkingPoint TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ROAD_MARKING_POINT_ROAD_SIGN
{
    static TCategoryId id() { return "road_marking_point_road_sign"; }
    typedef RoadMarkingPoint TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ROAD_MARKING_POINT_ROAD_SIGN_SPEED_LIMIT
{
    static TCategoryId id() { return "road_marking_point_road_sign_speed_limit"; }
    typedef RoadMarkingPoint TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

struct ROAD_MARKING_POINT_TEXT
{
    static TCategoryId id() { return "road_marking_point_text"; }
    typedef RoadMarkingPoint TObject;
    typedef GeomObjectsView<TObject> TObjectsView;
};

} // namespace categories
} // namespace maps::wiki::validator
