#pragma once

#ifndef YANDEX_MAPS_WIKI_VALIDATOR_CHECK_INL
#error "Direct inclusion of check-inl.h is not allowed, " \
    "please include check.h instead"
#endif

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace validator {

template<class TCheckPart>
void CheckRegistry::registerCheckPart(
        const std::string& moduleId,
        const TCheckId& checkId,
        const TCheckPartId& partId)
{
    auto& moduleInfo = modulesInfo_[moduleId];
    auto& checkPartsInfo = moduleInfo[checkId];
    if (partId.empty()) {
        REQUIRE(checkPartsInfo.empty(), "Attempt to redefine check");
    } else {
        REQUIRE(checkPartsInfo.size() != 1
                || !checkPartsInfo.begin()->first.empty(),
            "Attempt to add part to a simple check");
    }

    bool insertionSucceeded = checkPartsInfo.insert(std::make_pair(
            partId,
            CheckPartInfo{
                std::make_shared<TCheckPart>(),
                TCheckPart::categoryDependencies() }
        )).second;

    REQUIRE(insertionSucceeded, "Attempt to redefine check part");
}

namespace detail {

template<typename... Categories>
std::vector<TCategoryId> categoryNames()
{ return std::vector<TCategoryId>{Categories::id()...}; }

}

#undef VALIDATOR_CHECK_PART
#define VALIDATOR_CHECK_PART(check_name, part_name, ...)               \
class check_name##_##part_name##_CheckPart                             \
        : public maps::wiki::validator::ICheckPart                     \
{                                                                      \
public:                                                                \
    void run(maps::wiki::validator::CheckContext*) override;           \
                                                                       \
    static std::vector<maps::wiki::validator::TCategoryId>             \
        categoryDependencies()                                         \
    {                                                                  \
        return maps::wiki::validator::detail                           \
            ::categoryNames<__VA_ARGS__>();                            \
    }                                                                  \
};                                                                     \
                                                                       \
maps::wiki::validator::CheckPartRegistrar<                             \
        check_name##_##part_name##_CheckPart>                          \
check_name##_##part_name##_CheckPart_registrar(                        \
    MODULE_NAME,                                                       \
    #check_name,                                                       \
    #part_name);                                                       \
                                                                       \
void check_name##_##part_name##_CheckPart::run(                        \
    maps::wiki::validator::CheckContext* context)

#undef VALIDATOR_SIMPLE_CHECK
#define VALIDATOR_SIMPLE_CHECK(check_name, ...)                        \
    VALIDATOR_CHECK_PART(check_name, , __VA_ARGS__)


} // namespace validator
} // namespace wiki
} // namespace maps
