#pragma once

#include <yandex/maps/wiki/revision/revisionid.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polygon.h>

#include <cstdint>
#include <map>
#include <string>
#include <unordered_set>
#include <vector>

namespace maps::wiki::validator {

typedef revision::DBID TId;
typedef revision::DBID DBID;
typedef revision::RevisionID RevisionID;

typedef std::vector<RevisionID> RevisionIds;

typedef std::unordered_set<TId> ObjectIdSet;

typedef std::string TCheckId;
typedef TCheckId TCheckPartId;
typedef std::map<std::string, std::string> AttrMap;
typedef unsigned long TSeqNum;

typedef std::string TCategoryId;
typedef int TFeatureType;

typedef std::string TIsoCode;

typedef int64_t TTaskId;

typedef int TSeconds;

typedef std::vector<geolib3::Point2> PointVector;
typedef std::vector<geolib3::Polygon2> PolygonVector;

struct Relation;
using Relations = std::vector<Relation>;

const double ZERO_AOI_BUFFER = 0.0;

} // namespace maps::wiki::validator
