#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <optional>

namespace maps::wiki::validator {

struct Relation
{
    Relation(
            TId other,
            TCategoryId otherCategoryId,
            std::string role,
            std::optional<TSeqNum> seqNum)
        : other(std::move(other))
        , otherCategoryId(std::move(otherCategoryId))
        , role(std::move(role))
        , seqNum(std::move(seqNum))
    {}

    TId other;
    TCategoryId otherCategoryId;
    std::string role;
    std::optional<TSeqNum> seqNum;
};

} // namespace maps::wiki::validator
