#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <maps/libs/geolib/include/bounding_box.h>

#include <functional>
#include <vector>
#include <memory>

namespace maps::wiki::validator {

template<class Object>
class GeomObjectsView
{
public:
    ~GeomObjectsView();

    void visit(std::function<void(const Object*)> visitor) const;
    void batchVisit(
            std::function<void(const Object*)> visitor,
            size_t batchSize) const;
    void batchVisitObjects(
            const std::vector<const Object*>& objects,
            std::function<void(const Object*)> visitor,
            size_t batchSize) const;

    bool loaded(TId id) const;

    const Object* byId(TId id) const;

    std::vector<const Object*>
    byBbox(const maps::geolib3::BoundingBox& bbox) const;

private:
    class Impl;
    GeomObjectsView(Impl* impl);
    friend class ObjectsCollectionBase;

private:
    std::unique_ptr<Impl> impl_;
};

} // namespace maps::wiki::validator
