#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <functional>
#include <vector>
#include <memory>

namespace maps {
namespace wiki {
namespace validator {

template<class Object>
class ObjectsView
{
public:
    ~ObjectsView();

    void visit(std::function<void(const Object*)> visitor) const;
    void batchVisit(
            std::function<void(const Object*)> visitor,
            size_t batchSize) const;
    void batchVisitObjects(
            const std::vector<const Object*>& objects,
            std::function<void(const Object*)> visitor,
            size_t batchSize) const;

    bool loaded(TId id) const;

    const Object* byId(TId id) const;

private:
    class Impl;
    ObjectsView(Impl* impl);
    friend class ObjectsCollectionBase;

private:
    std::unique_ptr<Impl> impl_;
};

} // namespace validator
} // namespace wiki
} // namespace maps
