#pragma once

namespace maps::wiki::validator {

// Determines whether TObject has nested TGeom typedef
template<class TObject>
class HasGeom
{
    typedef char no[1];
    typedef char yes[2];

    template<class T>
    static yes& test(typename T::TGeom*);

    template<class>
    static no& test(...);

public:
    static const bool value = sizeof(test<TObject>(nullptr)) == sizeof(yes);
};

} // namespace maps::wiki::validator

