#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/geolib/include/point.h>

#include <vector>

namespace maps::wiki::validator {

class AddressPoint {
public:
    using TGeom = geolib3::Point2;

    struct AssociatedObject {
        enum class Type
        {
            NotSet,
            AdmUnit,
            Road,
            Feature
        };

        TId id;
        Type type;
    };


    AddressPoint(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    AssociatedObject associatedObject() const
    { return associatedObject_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    const std::vector<TId>& arrivalPoints() const
    { return arrivalPoints_; }

private:
    TId id_;
    TGeom geom_;
    AssociatedObject associatedObject_;
    std::vector<NameRelation> names_;
    std::vector<TId> arrivalPoints_;
};

} // namespace maps::wiki::validator
