#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/adm_unit_common.h>
#include <yandex/maps/wiki/validator/objects/name.h>

namespace maps::wiki::validator {

class AdmUnit : public AdmUnitCommon
{
public:
    AdmUnit(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId center() const
    { return center_; }

    bool isLeaf() const
    { return isLeaf_; }

    bool isAddrUnity() const
    { return isAddrUnity_; }

    TId addrUnity() const
    { return addrUnity_; }

private:
    TId center_;
    TId addrUnity_;
    bool isLeaf_;
    bool isAddrUnity_;
};

} // namespace maps::wiki::validator
