#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>

#include <vector>

namespace maps::wiki::validator {

class AdmUnitCommon
{
public:
    enum class LevelKind {
        Country = 1,
        Province = 2,
        Area = 3,
        Locality = 4,
        District = 5,
        Other = 6,
        Block = 7,

        Min = Country,
        Max = Block
    };

    TId id() const
    { return id_; }

    LevelKind levelKind() const
    { return levelKind_; }

    const TIsoCode& isoCode() const
    { return isoCode_; }

    bool isTown() const
    { return isTown_; }

    bool isInformal() const
    { return isInformal_; }

    bool isMunicipality() const
    { return isMunicipality_; }

    TId parent() const
    { return parent_; }

    const std::vector<TId>& faces() const
    { return faces_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    const std::vector<TId>& addressExclusions() const
    { return addressExclusions_; }

    const std::vector<TIsoCode>& recognitionIsoCodes() const
    { return recognitionIsoCodes_; }

    const std::string& geobaseId() const
    { return geobaseId_; }

protected:
    AdmUnitCommon(
        TId id,
        const std::string& childRoleId,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    ~AdmUnitCommon() = default;

private:
    TId id_;
    LevelKind levelKind_;
    TIsoCode isoCode_;
    bool isTown_;
    bool isInformal_;
    bool isMunicipality_;

    TId parent_;

    std::vector<TId> faces_;
    std::vector<NameRelation> names_;
    std::vector<TId> addressExclusions_;

    std::vector<TIsoCode> recognitionIsoCodes_;

    std::string geobaseId_;
};

} // namespace maps::wiki::validator
