#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/geolib/include/point.h>

#include <vector>

namespace maps::wiki::validator {

class ArrivalPoint {
public:
    using TGeom = geolib3::Point2;

    ArrivalPoint(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const ArrivalPoint::TGeom& geom() const
    { return geom_; }

    TId parentId() const
    { return parentId_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    bool isMajor() const
    { return isMajor_; }

    bool dropoffPickup() const
    { return dropoffPickup_; }

private:
    TId id_;
    TGeom geom_;
    TId parentId_;
    std::vector<NameRelation> names_;
    bool isMajor_;
    bool dropoffPickup_;
};

} // namespace maps::wiki::validator
