#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <maps/libs/geolib/include/polygon.h>

namespace maps::wiki::validator {

class Building
{
public:
    using TGeom = geolib3::Polygon2;

    Building(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TFeatureType featureType() const
    { return featureType_; }

    const TGeom& geom() const
    { return geom_; }

    const std::string& height() const
    { return height_; }

private:
    TId id_;
    TFeatureType featureType_;
    TGeom geom_;
    std::string height_;
};

} // namespace maps::wiki::validator
