#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <maps/libs/geolib/include/point.h>

namespace maps::wiki::validator {

class Center
{
public:
    using TGeom = geolib3::Point2;

    Center(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId parent() const
    { return parent_; }

    const TGeom& geom() const
    { return geom_; }

private:
    TId id_;
    TId parent_;
    TGeom geom_;
};

} // namespace maps::wiki::validator
