#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <yandex/maps/wiki/validator/common/relation.h>

#include <vector>

namespace maps::wiki::validator {

class CondAnnotation
{
public:
    CondAnnotation(
            TId id,
            const AttrMap& attributes,
            const Relations& /* masters */,
            const Relations& slaves);

    TId id() const
    { return id_; }

    TId annotationId() const
    { return annotationId_; }

    TId viaJunction() const
    { return viaJunction_; }

    TId fromRoadElement() const
    { return fromRoadElement_; }

    const std::vector<std::pair<TSeqNum, TId>>& toRoadElements() const
    { return toRoadElements_; }

private:
    TId id_;
    TId annotationId_;
    TId viaJunction_;
    TId fromRoadElement_;
    std::vector<std::pair<TSeqNum, TId>> toRoadElements_;
};

} // namespace maps::wiki::validator
